//
//  ZYJMQTTProperties.h
//  ZYJMQTTClient
//
//  Created by Christoph Krey on 04.04.17.
//  Copyright © 2017 Christoph Krey. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(UInt8, ZYJMQTTPropertyIdentifier) {
    ZYJMQTTPayloadFormatIndicator = 1,
    ZYJMQTTPublicationExpiryInterval = 2,
    ZYJMQTTContentType = 3,
    ZYJMQTTResponseTopic = 8,
    ZYJMQTTCorrelationData = 9,
    ZYJMQTTSubscriptionIdentifier = 11,
    ZYJMQTTSessionExpiryInterval = 17,
    ZYJMQTTAssignedClientIdentifier = 18,
    ZYJMQTTServerKeepAlive = 19,
    ZYJMQTTAuthMethod = 21,
    ZYJMQTTAuthData = 22,
    ZYJMQTTRequestProblemInformation = 23,
    ZYJMQTTWillDelayInterval = 24,
    ZYJMQTTRequestResponseInformation = 25,
    ZYJMQTTResponseInformation = 26,
    ZYJMQTTServerReference = 28,
    ZYJMQTTReasonString = 31,
    ZYJMQTTReceiveMaximum = 33,
    ZYJMQTTTopicAliasMaximum = 34,
    ZYJMQTTTopicAlias = 35,
    ZYJMQTTMaximumQoS = 36,
    ZYJMQTTRetainAvailable = 37,
    ZYJMQTTUserProperty = 38,
    ZYJMQTTMaximumPacketSize = 39,
    ZYJMQTTWildcardSubscriptionAvailable = 40,
    ZYJMQTTSubscriptionIdentifiersAvailable = 41,
    ZYJMQTTSharedSubscriptionAvailable = 42
};


@interface ZYJMQTTProperties : NSObject

@property (strong, nonatomic) NSNumber *payloadFormatIndicator;
@property (strong, nonatomic) NSNumber *publicationExpiryInterval;
@property (strong, nonatomic) NSString *contentType;
@property (strong, nonatomic) NSString *responseTopic;
@property (strong, nonatomic) NSData *correlationData;
@property (strong, nonatomic) NSNumber *subscriptionIdentifier;
@property (strong, nonatomic) NSNumber *sessionExpiryInterval;
@property (strong, nonatomic) NSString *assignedClientIdentifier;
@property (strong, nonatomic) NSNumber *serverKeepAlive;
@property (strong, nonatomic) NSString *authMethod;
@property (strong, nonatomic) NSData *authData;
@property (strong, nonatomic) NSNumber *requestProblemInformation;
@property (strong, nonatomic) NSNumber *willDelayInterval;
@property (strong, nonatomic) NSNumber *requestResponseInformation;
@property (strong, nonatomic) NSString *responseInformation;
@property (strong, nonatomic) NSString *serverReference;
@property (strong, nonatomic) NSString *reasonString;
@property (strong, nonatomic) NSNumber *receiveMaximum;
@property (strong, nonatomic) NSNumber *topicAliasMaximum;
@property (strong, nonatomic) NSNumber *topicAlias;
@property (strong, nonatomic) NSNumber *maximumQoS;
@property (strong, nonatomic) NSNumber *retainAvailable;
@property (strong, nonatomic) NSMutableDictionary <NSString *, NSString *> *userProperty;
@property (strong, nonatomic) NSNumber *maximumPacketSize;
@property (strong, nonatomic) NSNumber *wildcardSubscriptionAvailable;
@property (strong, nonatomic) NSNumber *subscriptionIdentifiersAvailable;
@property (strong, nonatomic) NSNumber *sharedSubscriptionAvailable;

- (instancetype)initFromData:(NSData *)data NS_DESIGNATED_INITIALIZER;
+ (int)getVariableLength:(NSData *)data;
+ (int)variableIntLength:(int)length;

@end
