//
//  ZYJMQTTLog.h
//  ZYJMQTTClient
//
//  Created by Christoph Krey on 10.02.16.
//  Copyright © 2016-2017 Christoph Krey. All rights reserved.
//

@import Foundation;

static const NSString *OffcnIMSDKiOSZYJMQTTVersion = @"1.4.3";

#define NSLog(format, ...) do {                                             \
fprintf(stderr, "<%s : %d> %s\n",                                           \
[[[NSString stringWithUTF8String:__FILE__] lastPathComponent] UTF8String],  \
__LINE__, __func__);                                                        \
(NSLog)((format), ##__VA_ARGS__);                                           \
fprintf(stderr, "-------\n");                                               \
} while (0)
#undef NSLog
#if       DEBUG
#define NSLog(FORMAT, ...) fprintf(stderr,"\nfunction:%s line:%d content:%s\n", __FUNCTION__, __LINE__, [[NSString stringWithFormat:FORMAT, ##__VA_ARGS__] UTF8String]);
#else
#define NSLog(FORMAT, ...)
#endif


/** ZYJMQTTLog lets you define the log level for ZYJMQTTClient
 *  independently of using CocoaLumberjack
 */
@interface ZYJMQTTLog: NSObject


@end
