//
// ZYJMQTTCFSocketEncoder.h
// ZYJMQTTClient.framework
//
// Copyright © 2013-2017, Christoph Krey. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, ZYJMQTTCFSocketEncoderState) {
    ZYJMQTTCFSocketEncoderStateInitializing,
    ZYJMQTTCFSocketEncoderStateReady,
    ZYJMQTTCFSocketEncoderStateError
};

@class ZYJMQTTCFSocketEncoder;

@protocol ZYJMQTTCFSocketEncoderDelegate <NSObject>

- (void)encoderDidOpen:(ZYJMQTTCFSocketEncoder *)sender;
- (void)encoder:(ZYJMQTTCFSocketEncoder *)sender didFailWithError:(NSError *)error;
- (void)encoderdidClose:(ZYJMQTTCFSocketEncoder *)sender;

@end

@interface ZYJMQTTCFSocketEncoder : NSObject <NSStreamDelegate>

@property (nonatomic) ZYJMQTTCFSocketEncoderState state;
@property (strong, nonatomic) NSError *error;
@property (strong, nonatomic) NSOutputStream *stream;
@property (weak, nonatomic ) id<ZYJMQTTCFSocketEncoderDelegate> delegate;

- (void)open;
- (void)close;
- (BOOL)send:(NSData *)data;

@end

