//
// ZYJMQTTCFSocketDecoder.h
// ZYJMQTTClient.framework
// 
// Copyright © 2013-2017, Christoph Krey. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, ZYJMQTTCFSocketDecoderState) {
    ZYJMQTTCFSocketDecoderStateInitializing,
    ZYJMQTTCFSocketDecoderStateReady,
    ZYJMQTTCFSocketDecoderStateError
};

@class ZYJMQTTCFSocketDecoder;

@protocol ZYJMQTTCFSocketDecoderDelegate <NSObject>

- (void)decoder:(ZYJMQTTCFSocketDecoder *)sender didReceiveMessage:(NSData *)data;
- (void)decoderDidOpen:(ZYJMQTTCFSocketDecoder *)sender;
- (void)decoder:(ZYJMQTTCFSocketDecoder *)sender didFailWithError:(NSError *)error;
- (void)decoderdidClose:(ZYJMQTTCFSocketDecoder *)sender;

@end

@interface ZYJMQTTCFSocketDecoder : NSObject <NSStreamDelegate>

@property (nonatomic) ZYJMQTTCFSocketDecoderState state;
@property (strong, nonatomic) NSError *error;
@property (strong, nonatomic) NSInputStream *stream;
@property (weak, nonatomic ) id<ZYJMQTTCFSocketDecoderDelegate> delegate;

- (void)open;
- (void)close;

@end


