//  代码地址: https://github.com/CoderMJLee/ZYJMJRefresh
//  代码地址: http://code4app.com/ios/%E5%BF%AB%E9%80%9F%E9%9B%86%E6%88%90%E4%B8%8B%E6%8B%89%E4%B8%8A%E6%8B%89%E5%88%B7%E6%96%B0/52326ce26803fabc46000000
#import <UIKit/UIKit.h>
#import <objc/message.h>

// 弱引用
#define MJWeakSelf __weak typeof(self) weakSelf = self;

// 日志输出
#ifdef DEBUG
#define ZYJMJRefreshLog(...) NSLog(__VA_ARGS__)
#else
#define ZYJMJRefreshLog(...)
#endif

// 过期提醒
#define ZYJMJRefreshDeprecated(instead) NS_DEPRECATED(2_0, 2_0, 2_0, 2_0, instead)

// 运行时objc_msgSend
#define ZYJMJRefreshMsgSend(...) ((void (*)(void *, SEL, UIView *))objc_msgSend)(__VA_ARGS__)
#define ZYJMJRefreshMsgTarget(target) (__bridge void *)(target)

// RGB颜色
#define ZYJMJRefreshColor(r, g, b) [UIColor colorWithRed:(r)/255.0 green:(g)/255.0 blue:(b)/255.0 alpha:1.0]

// 文字颜色
#define ZYJMJRefreshLabelTextColor ZYJMJRefreshColor(90, 90, 90)

// 字体大小
#define ZYJMJRefreshLabelFont [UIFont boldSystemFontOfSize:14]

// 常量
UIKIT_EXTERN const CGFloat ZYJMJRefreshLabelLeftInset;
UIKIT_EXTERN const CGFloat ZYJMJRefreshHeaderHeight;
UIKIT_EXTERN const CGFloat ZYJMJRefreshFooterHeight;
UIKIT_EXTERN const CGFloat ZYJMJRefreshFastAnimationDuration;
UIKIT_EXTERN const CGFloat ZYJMJRefreshSlowAnimationDuration;

UIKIT_EXTERN NSString *const ZYJMJRefreshKeyPathContentOffset;
UIKIT_EXTERN NSString *const ZYJMJRefreshKeyPathContentSize;
UIKIT_EXTERN NSString *const ZYJMJRefreshKeyPathContentInset;
UIKIT_EXTERN NSString *const ZYJMJRefreshKeyPathPanState;

UIKIT_EXTERN NSString *const ZYJMJRefreshHeaderLastUpdatedTimeKey;

UIKIT_EXTERN NSString *const ZYJMJRefreshHeaderIdleText;
UIKIT_EXTERN NSString *const ZYJMJRefreshHeaderPullingText;
UIKIT_EXTERN NSString *const ZYJMJRefreshHeaderRefreshingText;

UIKIT_EXTERN NSString *const ZYJMJRefreshAutoFooterIdleText;
UIKIT_EXTERN NSString *const ZYJMJRefreshAutoFooterRefreshingText;
UIKIT_EXTERN NSString *const ZYJMJRefreshAutoFooterNoMoreDataText;

UIKIT_EXTERN NSString *const ZYJMJRefreshBackFooterIdleText;
UIKIT_EXTERN NSString *const ZYJMJRefreshBackFooterPullingText;
UIKIT_EXTERN NSString *const ZYJMJRefreshBackFooterRefreshingText;
UIKIT_EXTERN NSString *const ZYJMJRefreshBackFooterNoMoreDataText;

UIKIT_EXTERN NSString *const ZYJMJRefreshHeaderLastTimeText;
UIKIT_EXTERN NSString *const ZYJMJRefreshHeaderDateTodayText;
UIKIT_EXTERN NSString *const ZYJMJRefreshHeaderNoneLastDateText;

// 状态检查
#define ZYJMJRefreshCheckState \
ZYJMJRefreshState oldState = self.state; \
if (state == oldState) return; \
[super setState:state];
