//  代码地址: https://github.com/CoderMJLee/ZYJMJRefresh
//  代码地址: http://code4app.com/ios/%E5%BF%AB%E9%80%9F%E9%9B%86%E6%88%90%E4%B8%8B%E6%8B%89%E4%B8%8A%E6%8B%89%E5%88%B7%E6%96%B0/52326ce26803fabc46000000
//  UIScrollView+ZYJMJRefresh.m
//  ZYJMJRefreshExample
//
//  Created by MJ Lee on 15/3/4.
//  Copyright (c) 2015年 小码哥. All rights reserved.
//

#import "UIScrollView+ZYJMJRefresh.h"
#import "ZYJMJRefreshHeader.h"
#import "ZYJMJRefreshFooter.h"
#import <objc/runtime.h>

@implementation NSObject (ZYJMJRefresh)

+ (void)ZYJ_exchangeInstanceMethod1:(SEL)method1 method2:(SEL)method2
{
    method_exchangeImplementations(class_getInstanceMethod(self, method1), class_getInstanceMethod(self, method2));
}

+ (void)ZYJ_exchangeClassMethod1:(SEL)method1 method2:(SEL)method2
{
    method_exchangeImplementations(class_getClassMethod(self, method1), class_getClassMethod(self, method2));
}

@end

@implementation UIScrollView (ZYJMJRefresh)

#pragma mark - header
static const char ZYJMJRefreshHeaderKey = '\0';
- (void)setMj_ZYJheader:(ZYJMJRefreshHeader *)mj_ZYJheader
{
    if (mj_ZYJheader != self.mj_ZYJheader) {
        // 删除旧的，添加新的
        [self.mj_ZYJheader removeFromSuperview];
        [self insertSubview:mj_ZYJheader atIndex:0];
        
        // 存储新的
        [self willChangeValueForKey:@"mj_ZYJheader"]; // KVO
        objc_setAssociatedObject(self, &ZYJMJRefreshHeaderKey,
                                 mj_ZYJheader, OBJC_ASSOCIATION_ASSIGN);
        [self didChangeValueForKey:@"mj_ZYJheader"]; // KVO
    }
}

- (ZYJMJRefreshHeader *)mj_ZYJheader
{
    return objc_getAssociatedObject(self, &ZYJMJRefreshHeaderKey);
}

#pragma mark - footer
static const char ZYJMJRefreshFooterKey = '\0';
- (void)setMj_ZYJfooter:(ZYJMJRefreshFooter *)mj_ZYJfooter
{
    if (mj_ZYJfooter != self.mj_ZYJfooter) {
        // 删除旧的，添加新的
        [self.mj_ZYJfooter removeFromSuperview];
        [self insertSubview:mj_ZYJfooter atIndex:0];
        
        // 存储新的
        [self willChangeValueForKey:@"mj_ZYJfooter"]; // KVO
        objc_setAssociatedObject(self, &ZYJMJRefreshFooterKey,
                                 mj_ZYJfooter, OBJC_ASSOCIATION_ASSIGN);
        [self didChangeValueForKey:@"mj_ZYJfooter"]; // KVO
    }
}

- (ZYJMJRefreshFooter *)mj_ZYJfooter
{
    return objc_getAssociatedObject(self, &ZYJMJRefreshFooterKey);
}

#pragma mark - 过期
- (void)setFooter:(ZYJMJRefreshFooter *)footer
{
    self.mj_ZYJfooter = footer;
}

- (ZYJMJRefreshFooter *)footer
{
    return self.mj_ZYJfooter;
}

- (void)setHeader:(ZYJMJRefreshHeader *)header
{
    self.mj_ZYJheader = header;
}

- (ZYJMJRefreshHeader *)header
{
    return self.mj_ZYJheader;
}

#pragma mark - other
- (NSInteger)mj_ZYJtotalDataCount
{
    NSInteger totalCount = 0;
    if ([self isKindOfClass:[UITableView class]]) {
        UITableView *tableView = (UITableView *)self;
        
        for (NSInteger section = 0; section<tableView.numberOfSections; section++) {
            totalCount += [tableView numberOfRowsInSection:section];
        }
    } else if ([self isKindOfClass:[UICollectionView class]]) {
        UICollectionView *collectionView = (UICollectionView *)self;
        
        for (NSInteger section = 0; section<collectionView.numberOfSections; section++) {
            totalCount += [collectionView numberOfItemsInSection:section];
        }
    }
    return totalCount;
}

static const char ZYJMJRefreshReloadDataBlockKey = '\0';
- (void)setMj_ZYJreloadDataBlock:(void (^)(NSInteger))mj_ZYJreloadDataBlock
{
    [self willChangeValueForKey:@"mj_ZYJreloadDataBlock"]; // KVO
    objc_setAssociatedObject(self, &ZYJMJRefreshReloadDataBlockKey, mj_ZYJreloadDataBlock, OBJC_ASSOCIATION_COPY_NONATOMIC);
    [self didChangeValueForKey:@"mj_ZYJreloadDataBlock"]; // KVO
}

- (void (^)(NSInteger))mj_ZYJreloadDataBlock
{
    return objc_getAssociatedObject(self, &ZYJMJRefreshReloadDataBlockKey);
}

- (void)executeReloadDataBlock
{
    !self.mj_ZYJreloadDataBlock ? : self.mj_ZYJreloadDataBlock(self.mj_ZYJtotalDataCount);
}
@end

@implementation UITableView (ZYJMJRefresh)

+ (void)load
{
    [self ZYJ_exchangeInstanceMethod1:@selector(reloadData) method2:@selector(mj_ZYJreloadData)];
}

- (void)mj_ZYJreloadData
{
    [self mj_ZYJreloadData];
    
    [self executeReloadDataBlock];
}
@end

@implementation UICollectionView (ZYJMJRefresh)

+ (void)load
{
    [self ZYJ_exchangeInstanceMethod1:@selector(reloadData) method2:@selector(mj_ZYJreloadData)];
}

- (void)mj_ZYJreloadData
{
    [self mj_ZYJreloadData];
    
    [self executeReloadDataBlock];
}
@end
