//
//  ZYJMJRefreshAutoFooter.m
//  ZYJMJRefreshExample
//
//  Created by MJ Lee on 15/4/24.
//  Copyright (c) 2015年 小码哥. All rights reserved.
//

#import "ZYJMJRefreshAutoFooter.h"

@interface ZYJMJRefreshAutoFooter()
@end

@implementation ZYJMJRefreshAutoFooter

#pragma mark - 初始化
- (void)willMoveToSuperview:(UIView *)newSuperview
{
    [super willMoveToSuperview:newSuperview];
    
    if (newSuperview) { // 新的父控件
        if (self.hidden == NO) {
            self.scrollView.mj_ZYJinsetB += self.mj_ZYJh;
        }
        
        // 设置位置
        self.mj_ZYJy = _scrollView.mj_ZYJcontentH;
    } else { // 被移除了
        if (self.hidden == NO) {
            self.scrollView.mj_ZYJinsetB -= self.mj_ZYJh;
        }
    }
}

#pragma mark - 过期方法
- (void)setAppearencePercentTriggerAutoRefresh:(CGFloat)appearencePercentTriggerAutoRefresh
{
    self.triggerAutomaticallyRefreshPercent = appearencePercentTriggerAutoRefresh;
}

- (CGFloat)appearencePercentTriggerAutoRefresh
{
    return self.triggerAutomaticallyRefreshPercent;
}

#pragma mark - 实现父类的方法
- (void)prepare
{
    [super prepare];
    
    // 默认底部控件100%出现时才会自动刷新
    self.triggerAutomaticallyRefreshPercent = 1.0;
    
    // 设置为默认状态
    self.automaticallyRefresh = YES;
}

- (void)scrollViewContentSizeDidChange:(NSDictionary *)change
{
    [super scrollViewContentSizeDidChange:change];
    
    // 设置位置
    self.mj_ZYJy = self.scrollView.mj_ZYJcontentH;
}

- (void)scrollViewContentOffsetDidChange:(NSDictionary *)change
{
    [super scrollViewContentOffsetDidChange:change];
    
    if (self.state != ZYJMJRefreshStateIdle || !self.automaticallyRefresh || self.mj_ZYJy == 0) return;
    
    if (_scrollView.mj_ZYJinsetT + _scrollView.mj_ZYJcontentH > _scrollView.mj_ZYJh) { // 内容超过一个屏幕
        // 这里的_scrollView.mj_ZYJcontentH替换掉self.mj_ZYJy更为合理
        if (_scrollView.mj_ZYJoffsetY >= _scrollView.mj_ZYJcontentH - _scrollView.mj_ZYJh + self.mj_ZYJh * self.triggerAutomaticallyRefreshPercent + _scrollView.mj_ZYJinsetB - self.mj_ZYJh) {
            // 防止手松开时连续调用
            CGPoint old = [change[@"old"] CGPointValue];
            CGPoint new = [change[@"new"] CGPointValue];
            if (new.y <= old.y) return;
            
            // 当底部刷新控件完全出现时，才刷新
            [self beginRefreshing];
        }
    }
}

- (void)scrollViewPanStateDidChange:(NSDictionary *)change
{
    [super scrollViewPanStateDidChange:change];
    
    if (self.state != ZYJMJRefreshStateIdle) return;
    
    if (_scrollView.panGestureRecognizer.state == UIGestureRecognizerStateEnded) {// 手松开
        if (_scrollView.mj_ZYJinsetT + _scrollView.mj_ZYJcontentH <= _scrollView.mj_ZYJh) {  // 不够一个屏幕
            if (_scrollView.mj_ZYJoffsetY >= - _scrollView.mj_ZYJinsetT) { // 向上拽
                [self beginRefreshing];
            }
        } else { // 超出一个屏幕
            if (_scrollView.mj_ZYJoffsetY >= _scrollView.mj_ZYJcontentH + _scrollView.mj_ZYJinsetB - _scrollView.mj_ZYJh) {
                [self beginRefreshing];
            }
        }
    }
}

- (void)setState:(ZYJMJRefreshState)state
{
    ZYJMJRefreshCheckState
    
    if (state == ZYJMJRefreshStateRefreshing) {
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.5 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            [self executeRefreshingCallback];
        });
    } else if (state == ZYJMJRefreshStateNoMoreData || state == ZYJMJRefreshStateIdle) {
        if (ZYJMJRefreshStateRefreshing == oldState) {
            if (self.endRefreshingCompletionBlock) {
                self.endRefreshingCompletionBlock();
            }
        }
    }
}

- (void)setHidden:(BOOL)hidden
{
    BOOL lastHidden = self.isHidden;
    
    [super setHidden:hidden];
    
    if (!lastHidden && hidden) {
        self.state = ZYJMJRefreshStateIdle;
        
        self.scrollView.mj_ZYJinsetB -= self.mj_ZYJh;
    } else if (lastHidden && !hidden) {
        self.scrollView.mj_ZYJinsetB += self.mj_ZYJh;
        
        // 设置位置
        self.mj_ZYJy = _scrollView.mj_ZYJcontentH;
    }
}
@end
