
#ifndef __ZYJMJExtensionConst__H__
#define __ZYJMJExtensionConst__H__

#import <Foundation/Foundation.h>

// 过期
#define ZYJMJExtensionDeprecated(instead) NS_DEPRECATED(2_0, 2_0, 2_0, 2_0, instead)

// 构建错误
#define ZYJMJExtensionBuildError(clazz, msg) \
NSError *error = [NSError errorWithDomain:msg code:250 userInfo:nil]; \
[clazz setMj_ZYJerror:error];

// 日志输出
#ifdef DEBUG
#define ZYJMJExtensionLog(...) NSLog(__VA_ARGS__)
#else
#define ZYJMJExtensionLog(...)
#endif

/**
 * 断言
 * @param condition   条件
 * @param returnValue 返回值
 */
#define ZYJMJExtensionAssertError(condition, returnValue, clazz, msg) \
[clazz setMj_ZYJerror:nil]; \
if ((condition) == NO) { \
    ZYJMJExtensionBuildError(clazz, msg); \
    return returnValue;\
}

#define ZYJMJExtensionAssert2(condition, returnValue) \
if ((condition) == NO) return returnValue;

/**
 * 断言
 * @param condition   条件
 */
#define ZYJMJExtensionAssert(condition) ZYJMJExtensionAssert2(condition, )

/**
 * 断言
 * @param param         参数
 * @param returnValue   返回值
 */
#define ZYJMJExtensionAssertParamNotNil2(param, returnValue) \
ZYJMJExtensionAssert2((param) != nil, returnValue)

/**
 * 断言
 * @param param   参数
 */
#define ZYJMJExtensionAssertParamNotNil(param) ZYJMJExtensionAssertParamNotNil2(param, )

/**
 * 打印所有的属性
 */
#define MJLogAllIvars \
-(NSString *)description \
{ \
    return [self mj_ZYJkeyValues].description; \
}
#define ZYJMJExtensionLogAllProperties MJLogAllIvars

/**
 *  类型（属性类型）
 */
extern NSString *const ZYJMJPropertyTypeInt;
extern NSString *const ZYJMJPropertyTypeShort;
extern NSString *const ZYJMJPropertyTypeFloat;
extern NSString *const ZYJMJPropertyTypeDouble;
extern NSString *const ZYJMJPropertyTypeLong;
extern NSString *const ZYJMJPropertyTypeLongLong;
extern NSString *const ZYJMJPropertyTypeChar;
extern NSString *const ZYJMJPropertyTypeBOOL1;
extern NSString *const ZYJMJPropertyTypeBOOL2;
extern NSString *const ZYJMJPropertyTypePointer;

extern NSString *const ZYJMJPropertyTypeIvar;
extern NSString *const ZYJMJPropertyTypeMethod;
extern NSString *const ZYJMJPropertyTypeBlock;
extern NSString *const ZYJMJPropertyTypeClass;
extern NSString *const ZYJMJPropertyTypeSEL;
extern NSString *const ZYJMJPropertyTypeId;

#endif
