//
//  NSObject+ZYJMJProperty.h
//  ZYJMJExtensionExample
//
//  Created by MJ Lee on 15/4/17.
//  Copyright (c) 2015年 小码哥. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ZYJMJExtensionConst.h"

@class ZYJMJProperty;

/**
 *  遍历成员变量用的block
 *
 *  @param property 成员的包装对象
 *  @param stop   YES代表停止遍历，NO代表继续遍历
 */
typedef void (^MJPropertiesEnumeration)(ZYJMJProperty *property, BOOL *stop);

/** 将属性名换为其他key去字典中取值 */
typedef NSDictionary * (^MJReplacedKeyFromPropertyName)();
typedef id (^MJReplacedKeyFromPropertyName121)(NSString *propertyName);
/** 数组中需要转换的模型类 */
typedef NSDictionary * (^MJObjectClassInArray)();
/** 用于过滤字典中的值 */
typedef id (^MJNewValueFromOldValue)(id object, id oldValue, ZYJMJProperty *property);

/**
 * 成员属性相关的扩展
 */
@interface NSObject (ZYJMJProperty)
#pragma mark - 遍历
/**
 *  遍历所有的成员
 */
+ (void)mj_ZYJenumerateProperties:(MJPropertiesEnumeration)enumeration;

#pragma mark - 新值配置
/**
 *  用于过滤字典中的值
 *
 *  @param newValueFormOldValue 用于过滤字典中的值
 */
+ (void)mj_ZYJsetupNewValueFromOldValue:(MJNewValueFromOldValue)newValueFormOldValue;
+ (id)mj_ZYJgetNewValueFromObject:(__unsafe_unretained id)object oldValue:(__unsafe_unretained id)oldValue property:(__unsafe_unretained ZYJMJProperty *)property;

#pragma mark - key配置
/**
 *  将属性名换为其他key去字典中取值
 *
 *  @param replacedKeyFromPropertyName 将属性名换为其他key去字典中取值
 */
+ (void)mj_ZYJsetupReplacedKeyFromPropertyName:(MJReplacedKeyFromPropertyName)replacedKeyFromPropertyName;
/**
 *  将属性名换为其他key去字典中取值
 *
 *  @param replacedKeyFromPropertyName121 将属性名换为其他key去字典中取值
 */
+ (void)mj_ZYJsetupReplacedKeyFromPropertyName121:(MJReplacedKeyFromPropertyName121)replacedKeyFromPropertyName121;

#pragma mark - array model class配置
/**
 *  数组中需要转换的模型类
 *
 *  @param objectClassInArray          数组中需要转换的模型类
 */
+ (void)mj_ZYJsetupObjectClassInArray:(MJObjectClassInArray)objectClassInArray;
@end

@interface NSObject (ZYJMJPropertyDeprecated_v_2_5_16)
+ (void)enumerateProperties:(MJPropertiesEnumeration)enumeration ZYJMJExtensionDeprecated("请在方法名前面加上mj_ZYJ前缀，使用mj_ZYJ***");
+ (void)setupNewValueFromOldValue:(MJNewValueFromOldValue)newValueFormOldValue ZYJMJExtensionDeprecated("请在方法名前面加上mj_ZYJ前缀，使用mj_ZYJ***");
+ (id)getNewValueFromObject:(__unsafe_unretained id)object oldValue:(__unsafe_unretained id)oldValue property:(__unsafe_unretained ZYJMJProperty *)property ZYJMJExtensionDeprecated("请在方法名前面加上mj_ZYJ前缀，使用mj_ZYJ***");
+ (void)setupReplacedKeyFromPropertyName:(MJReplacedKeyFromPropertyName)replacedKeyFromPropertyName ZYJMJExtensionDeprecated("请在方法名前面加上mj_ZYJ前缀，使用mj_ZYJ***");
+ (void)setupReplacedKeyFromPropertyName121:(MJReplacedKeyFromPropertyName121)replacedKeyFromPropertyName121 ZYJMJExtensionDeprecated("请在方法名前面加上mj_ZYJ前缀，使用mj_ZYJ***");
+ (void)setupObjectClassInArray:(MJObjectClassInArray)objectClassInArray ZYJMJExtensionDeprecated("请在方法名前面加上mj_ZYJ前缀，使用mj_ZYJ***");
@end
