//
//  NSObject+ZYJMJCoding.h
//  ZYJMJExtension
//
//  Created by mj on 14-1-15.
//  Copyright (c) 2014年 小码哥. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ZYJMJExtensionConst.h"

/**
 *  Codeing协议
 */
@protocol ZYJMJCoding <NSObject>
@optional
/**
 *  这个数组中的属性名才会进行归档
 */
+ (NSArray *)mj_ZYJallowedCodingPropertyNames;
/**
 *  这个数组中的属性名将会被忽略：不进行归档
 */
+ (NSArray *)mj_ZYJignoredCodingPropertyNames;
@end

@interface NSObject (ZYJMJCoding) <ZYJMJCoding>
/**
 *  解码（从文件中解析对象）
 */
- (void)mj_ZYJdecode:(NSCoder *)decoder;
/**
 *  编码（将对象写入文件中）
 */
- (void)mj_ZYJencode:(NSCoder *)encoder;
@end

/**
 归档的实现
 */
#define ZYJMJCodingImplementation \
- (id)initWithCoder:(NSCoder *)decoder \
{ \
if (self = [super init]) { \
[self mj_ZYJdecode:decoder]; \
} \
return self; \
} \
\
- (void)encodeWithCoder:(NSCoder *)encoder \
{ \
[self mj_ZYJencode:encoder]; \
}

#define ZYJMJExtensionCodingImplementation ZYJMJCodingImplementation
