//
//  XMLDictionary.h
//
//  Version 1.4
//
//  Created by Nick Lockwood on 15/11/2010.
//  Copyright 2010 Charcoal Design. All rights reserved.
//
//  Get the latest version of XMLDictionary from here:
//
//  https://github.com/nicklockwood/XMLDictionary
//
//  This software is provided 'as-is', without any express or implied
//  warranty.  In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source distribution.
//

#import <Foundation/Foundation.h>
#import "ZYJOSSConstants.h"

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wobjc-missing-property-synthesis"
@interface ZYJOSSXMLDictionaryParser : NSObject <NSCopying>

+ (ZYJOSSXMLDictionaryParser *)sharedInstance;

@property (nonatomic, assign) BOOL collapseTextNodes; // defaults to YES
@property (nonatomic, assign) BOOL stripEmptyNodes;   // defaults to YES
@property (nonatomic, assign) BOOL trimWhiteSpace;    // defaults to YES
@property (nonatomic, assign) BOOL alwaysUseArrays;   // defaults to NO
@property (nonatomic, assign) BOOL preserveComments;  // defaults to NO
@property (nonatomic, assign) BOOL wrapRootNode;      // defaults to NO

@property (nonatomic, assign) ZYJOSSXMLDictionaryAttributesMode attributesMode;
@property (nonatomic, assign) ZYJOSSXMLDictionaryNodeNameMode nodeNameMode;

- (NSDictionary *)dictionaryWithParser:(NSXMLParser *)parser;
- (NSDictionary *)dictionaryWithData:(NSData *)data;
- (NSDictionary *)dictionaryWithString:(NSString *)string;
- (NSDictionary *)dictionaryWithFile:(NSString *)path;

@end


@interface NSDictionary (ZYJOSSXMLDictionary)

+ (NSDictionary *)ZYJOSS_dictionaryWithXMLParser:(NSXMLParser *)parser;
+ (NSDictionary *)ZYJOSS_dictionaryWithXMLData:(NSData *)data;
+ (NSDictionary *)ZYJOSS_dictionaryWithXMLString:(NSString *)string;
+ (NSDictionary *)ZYJOSS_dictionaryWithXMLFile:(NSString *)path;

- (NSDictionary *)ZYJOSS_attributes;
- (NSDictionary *)ZYJOSS_childNodes;
- (NSArray *)ZYJOSS_comments;
- (NSString *)ZYJOSS_nodeName;
- (NSString *)ZYJOSS_innerText;
- (NSString *)ZYJOSS_innerXML;
- (NSString *)ZYJOSS_XMLString;

- (NSArray *)ZYJOSS_arrayValueForKeyPath:(NSString *)keyPath;
- (NSString *)ZYJOSS_stringValueForKeyPath:(NSString *)keyPath;
- (NSDictionary *)ZYJOSS_dictionaryValueForKeyPath:(NSString *)keyPath;

@end


@interface NSString (ZYJOSSXMLDictionary)

- (NSString *)ZYJOSS_XMLEncodedString;

@end


#pragma GCC diagnostic pop
