//
//  ZYJOSSURLRequestRetryHandler.h
//  AliyunZYJOSSSDK
//
//  Created by huaixu on 2018/1/22.
//  Copyright © 2018年 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ZYJOSSConstants.h"

@class ZYJOSSNetworkingRequestDelegate;


NS_ASSUME_NONNULL_BEGIN

/**
 The retry handler interface
 */
@interface ZYJOSSURLRequestRetryHandler : NSObject

@property (nonatomic, assign) uint32_t maxRetryCount;


+ (instancetype)defaultRetryHandler;

- (ZYJOSSNetworkingRetryType)shouldRetry:(uint32_t)currentRetryCount
                      requestDelegate:(ZYJOSSNetworkingRequestDelegate *)delegate
                             response:(NSHTTPURLResponse *)response
                                error:(NSError *)error;

- (NSTimeInterval)timeIntervalForRetry:(uint32_t)currentRetryCount
                             retryType:(ZYJOSSNetworkingRetryType)retryType;
@end

NS_ASSUME_NONNULL_END
