//
//  ZYJOSSNetworkingRequestDelegate.h
//  AliyunZYJOSSSDK
//
//  Created by huaixu on 2018/1/22.
//  Copyright © 2018年 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ZYJOSSConstants.h"
#import "ZYJOSSTask.h"

@class ZYJOSSAllRequestNeededMessage;
@class ZYJOSSURLRequestRetryHandler;
@class ZYJOSSHttpResponseParser;

/**
 The proxy object class for each ZYJOSS request.
 */
@interface ZYJOSSNetworkingRequestDelegate : NSObject

@property (nonatomic, strong) NSMutableArray * interceptors;

@property (nonatomic, strong) NSMutableURLRequest *internalRequest;
@property (nonatomic, assign) ZYJOSSOperationType operType;
@property (nonatomic, assign) BOOL isAccessViaProxy;

@property (nonatomic, assign) BOOL isRequestCancelled;

@property (nonatomic, strong) ZYJOSSAllRequestNeededMessage *allNeededMessage;
@property (nonatomic, strong) ZYJOSSURLRequestRetryHandler *retryHandler;
@property (nonatomic, strong) ZYJOSSHttpResponseParser *responseParser;

@property (nonatomic, strong) NSData * uploadingData;
@property (nonatomic, strong) NSURL * uploadingFileURL;

@property (nonatomic, assign) int64_t payloadTotalBytesWritten;

@property (nonatomic, assign) BOOL isBackgroundUploadFileTask;
@property (nonatomic, assign) BOOL isHttpdnsEnable;


@property (nonatomic, assign) uint32_t currentRetryCount;
@property (nonatomic, strong) NSError * error;
@property (nonatomic, assign) BOOL isHttpRequestNotSuccessResponse;
@property (nonatomic, strong) NSMutableData *httpRequestNotSuccessResponseBody;

@property (atomic, strong) NSURLSessionDataTask *currentSessionTask;

@property (nonatomic, copy) ZYJOSSNetworkingUploadProgressBlock uploadProgress;
@property (nonatomic, copy) ZYJOSSNetworkingDownloadProgressBlock downloadProgress;
@property (nonatomic, copy) ZYJOSSNetworkingRetryBlock retryCallback;
@property (nonatomic, copy) ZYJOSSNetworkingCompletionHandlerBlock completionHandler;
@property (nonatomic, copy) ZYJOSSNetworkingOnRecieveDataBlock onRecieveData;

/**
 * when put object to server,client caculate crc64 code and assigns it to
 * this property.
 */
@property (nonatomic, copy) NSString *contentCRC;

/** last crc64 code */
@property (nonatomic, copy) NSString *lastCRC;

/**
 * determine whether to verify crc64 code
 */
@property (nonatomic, assign) BOOL crc64Verifiable;



- (ZYJOSSTask *)buildInternalHttpRequest;
- (void)reset;
- (void)cancel;

@end
