//
//  ZYJOSSNetworking.h
//  ZYJOSS_ios_sdk
//
//  Created by zhouzhuo on 8/16/15.
//  Copyright (c) 2015 aliyun.com. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ZYJOSSModel.h"

@class ZYJOSSSyncMutableDictionary;
@class ZYJOSSNetworkingRequestDelegate;
@class ZYJOSSExecutor;



/**
 Network parameters
 */
@interface ZYJOSSNetworkingConfiguration : NSObject
@property (nonatomic, assign) uint32_t maxRetryCount;
@property (nonatomic, assign) uint32_t maxConcurrentRequestCount;
@property (nonatomic, assign) BOOL enableBackgroundTransmitService;
@property (nonatomic, strong) NSString * backgroundSessionIdentifier;
@property (nonatomic, assign) NSTimeInterval timeoutIntervalForRequest;
@property (nonatomic, assign) NSTimeInterval timeoutIntervalForResource;
@property (nonatomic, strong) NSString * proxyHost;
@property (nonatomic, strong) NSNumber * proxyPort;
@end


/**
 The network interface which ZYJOSSClient uses for network read and write operations.
 */
@interface ZYJOSSNetworking : NSObject <NSURLSessionDelegate, NSURLSessionDataDelegate>
@property (nonatomic, strong) NSURLSession * session;
@property (nonatomic, assign) BOOL isUsingBackgroundSession;
@property (nonatomic, strong) ZYJOSSSyncMutableDictionary * sessionDelagateManager;
@property (nonatomic, strong) ZYJOSSNetworkingConfiguration * configuration;
@property (nonatomic, strong) ZYJOSSExecutor * taskExecutor;

- (instancetype)initWithConfiguration:(ZYJOSSNetworkingConfiguration *)configuration;
- (ZYJOSSTask *)sendRequest:(ZYJOSSNetworkingRequestDelegate *)request;
@end
