//
//  ZYJOSSLog.h
//  ZYJOSS_ios_sdk
//
//  Created by zhouzhuo on 8/16/15.
//  Copyright (c) 2015 aliyun.com. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ZYJOSSCocoaLumberjack.h"
static const ZYJOSSDDLogLevel ZYJOSSLogLevel = ZYJOSSDDLogLevelAll;

// colorful log configuration
// see https://github.com/robbiehanson/XcodeColors

#define XCODE_COLORS_ESCAPE @"\033["

#define XCODE_COLORS_RESET_FG  XCODE_COLORS_ESCAPE @"fg;" // Clear any foreground color
#define XCODE_COLORS_RESET_BG  XCODE_COLORS_ESCAPE @"bg;" // Clear any background color
#define XCODE_COLORS_RESET     XCODE_COLORS_ESCAPE @";"   // Clear any foreground or background color

#define ZYJOSSLogVerbose(frmt, ...)\
if ([ZYJOSSLog isLogEnable]) {\
ZYJOSSDDLogVerbose(@"[Verbose]: %@", [NSString stringWithFormat:(frmt), ##__VA_ARGS__]);\
}

#define ZYJOSSLogDebug(frmt, ...)\
if ([ZYJOSSLog isLogEnable]) {\
ZYJOSSDDLogDebug(@"[Debug]: %@", [NSString stringWithFormat:(frmt), ##__VA_ARGS__]);\
}

#define ZYJOSSLogDebugNoFile(frmt, ...)\
if ([ZYJOSSLog isLogEnable]) {\
NSLog(@"[Debug]: %@", [NSString stringWithFormat:(frmt), ##__VA_ARGS__]);\
}

#define ZYJOSSLogError(frmt, ...)\
if ([ZYJOSSLog isLogEnable]) {\
ZYJOSSDDLogError(@"[Error]: %@", [NSString stringWithFormat:(frmt), ##__VA_ARGS__]);\
}

#define ZYJOSSLogWarn(frmt, ...)\
if ([ZYJOSSLog isLogEnable]) {\
ZYJOSSDDLogWarn(@"[Warning]: %@", [NSString stringWithFormat:(frmt), ##__VA_ARGS__]);\
}

static BOOL isEnable;

@interface ZYJOSSLog : NSObject

+ (void)enableLog;
+ (void)disableLog;
+ (BOOL)isLogEnable;
@end
