//
//  ZYJOSSGetBucketInfoResult.h
//  AliyunZYJOSSSDK
//
//  Created by huaixu on 2018/7/10.
//  Copyright © 2018年 aliyun. All rights reserved.
//

#import "ZYJOSSResult.h"

@interface ZYJOSSBucketOwner : NSObject

@property (nonatomic, copy) NSString *userName;

@property (nonatomic, copy) NSString *userId;

@end

@interface ZYJOSSAccessControlList : NSObject

@property (nonatomic, copy) NSString *grant;

@end



@interface ZYJOSSGetBucketInfoResult : ZYJOSSResult

/// Created date.
@property (nonatomic, copy) NSString *creationDate;

/// Bucket name.
@property (nonatomic, copy) NSString *bucketName;

/// Bucket location.
@property (nonatomic, copy) NSString *location;

/// Storage class (Standard, IA, Archive)
@property (nonatomic, copy) NSString *storageClass;

/**
 Internal endpoint. It could be accessed within AliCloud under the same
 location.
 */
@property (nonatomic, copy) NSString *intranetEndpoint;

/**
 External endpoint.It could be accessed from anywhere.
 */
@property (nonatomic, copy) NSString *extranetEndpoint;

/// Bucket owner.
@property (nonatomic, strong) ZYJOSSBucketOwner *owner;

@property (nonatomic, strong) ZYJOSSAccessControlList *acl;

@end
