//
//  ZYJOSSNSLogger.m
//  AliyunZYJOSSiOS
//
//  Created by jingdan on 2017/10/24.
//  Copyright © 2017年 zhouzhuo. All rights reserved.
//

#import "ZYJOSSNSLogger.h"

static ZYJOSSNSLogger *sharedInstance;

@implementation ZYJOSSNSLogger
+ (instancetype)sharedInstance {
    static dispatch_once_t ZYJOSSNSLoggerOnceToken;
    
    dispatch_once(&ZYJOSSNSLoggerOnceToken, ^{
        sharedInstance = [[[self class] alloc] init];
    });
    
    return sharedInstance;
}

- (void)logMessage:(ZYJOSSDDLogMessage *)logMessage {
    NSString * message = _logFormatter ? [_logFormatter formatLogMessage:logMessage] : logMessage->_message;
    
    if (message) {
        NSLog(@"%@",message);
    }
}

@end
