//
//  ZYJOSSConstants.h
//  AliyunZYJOSSSDK
//
//  Created by huaixu on 2018/1/22.
//  Copyright © 2018年 aliyun. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NSString* _Nullable (^ZYJOSSCustomSignContentBlock) (NSString * contentToSign, NSError **error);
typedef NSData * _Nullable (^ZYJOSSResponseDecoderBlock) (NSData * data);

typedef void (^ZYJOSSNetworkingUploadProgressBlock) (int64_t bytesSent, int64_t totalBytesSent, int64_t totalBytesExpectedToSend);
typedef void (^ZYJOSSNetworkingDownloadProgressBlock) (int64_t bytesWritten, int64_t totalBytesWritten, int64_t totalBytesExpectedToWrite);
typedef void (^ZYJOSSNetworkingRetryBlock) (void);
typedef void (^ZYJOSSNetworkingCompletionHandlerBlock) (id _Nullable responseObject, NSError * _Nullable error);
typedef void (^ZYJOSSNetworkingOnRecieveDataBlock) (NSData * data);

/**
 The flag of verification about crc64
 */
typedef NS_ENUM(NSUInteger, ZYJOSSRequestCRCFlag) {
    ZYJOSSRequestCRCUninitialized,
    ZYJOSSRequestCRCOpen,
    ZYJOSSRequestCRCClosed
};

/**
 Retry type definition
 */
typedef NS_ENUM(NSInteger, ZYJOSSNetworkingRetryType) {
    ZYJOSSNetworkingRetryTypeUnknown,
    ZYJOSSNetworkingRetryTypeShouldRetry,
    ZYJOSSNetworkingRetryTypeShouldNotRetry,
    ZYJOSSNetworkingRetryTypeShouldRefreshCredentialsAndRetry,
    ZYJOSSNetworkingRetryTypeShouldCorrectClockSkewAndRetry
};

/**
 * @brief: The following constants are provided by ZYJOSSNetworking as pZYJOSSible operation types.
 */
typedef NS_ENUM(NSInteger, ZYJOSSOperationType) {
    ZYJOSSOperationTypeGetService,
    ZYJOSSOperationTypeCreateBucket,
    ZYJOSSOperationTypeDeleteBucket,
    ZYJOSSOperationTypeGetBucket,
    ZYJOSSOperationTypeGetBucketInfo,
    ZYJOSSOperationTypeGetBucketACL,
    ZYJOSSOperationTypeHeadObject,
    ZYJOSSOperationTypeGetObject,
    ZYJOSSOperationTypeGetObjectACL,
    ZYJOSSOperationTypePutObject,
    ZYJOSSOperationTypePutObjectACL,
    ZYJOSSOperationTypeAppendObject,
    ZYJOSSOperationTypeDeleteObject,
    ZYJOSSOperationTypeDeleteMultipleObjects,
    ZYJOSSOperationTypeCopyObject,
    ZYJOSSOperationTypeInitMultipartUpload,
    ZYJOSSOperationTypeUploadPart,
    ZYJOSSOperationTypeCompleteMultipartUpload,
    ZYJOSSOperationTypeAbortMultipartUpload,
    ZYJOSSOperationTypeListMultipart,
    ZYJOSSOperationTypeListMultipartUploads,
    ZYJOSSOperationTypeTriggerCallBack,
    ZYJOSSOperationTypeImagePersist,
    ZYJOSSOperationTypeRestoreObject,
    ZYJOSSOperationTypePutSymlink,
    ZYJOSSOperationTypeGetSymlink,
};

/**
 * @brief: The following constants are provided by ZYJOSSClient as pZYJOSSible error codes.
 */
typedef NS_ENUM(NSInteger, ZYJOSSClientErrorCODE) {
    ZYJOSSClientErrorCodeNetworkingFailWithResponseCode0,
    ZYJOSSClientErrorCodeSignFailed,
    ZYJOSSClientErrorCodeFileCantWrite,
    ZYJOSSClientErrorCodeInvalidArgument,
    ZYJOSSClientErrorCodeNilUploadid,
    ZYJOSSClientErrorCodeTaskCancelled,
    ZYJOSSClientErrorCodeNetworkError,
    ZYJOSSClientErrorCodeInvalidCRC,
    ZYJOSSClientErrorCodeCannotResumeUpload,
    ZYJOSSClientErrorCodeExcpetionCatched,
    ZYJOSSClientErrorCodeNotKnown
};

typedef NS_ENUM(NSInteger, ZYJOSSXMLDictionaryAttributesMode)
{
    ZYJOSSXMLDictionaryAttributesModePrefixed = 0, //default
    ZYJOSSXMLDictionaryAttributesModeDictionary,
    ZYJOSSXMLDictionaryAttributesModeUnprefixed,
    ZYJOSSXMLDictionaryAttributesModeDiscard
};


typedef NS_ENUM(NSInteger, ZYJOSSXMLDictionaryNodeNameMode)
{
    ZYJOSSXMLDictionaryNodeNameModeRootOnly = 0, //default
    ZYJOSSXMLDictionaryNodeNameModeAlways,
    ZYJOSSXMLDictionaryNodeNameModeNever
};

typedef NS_ENUM(NSInteger, ZYJOSSBucketStorageClass)
{
    ZYJOSSBucketStorageClassStandard,
    ZYJOSSBucketStorageClassIA,
    ZYJOSSBucketStorageClassArchive
};

typedef NSString * ZYJOSSXMLDictionaryAttributeName NS_EXTENSIBLE_STRING_ENUM;

OBJC_EXTERN ZYJOSSXMLDictionaryAttributeName const ZYJOSSXMLDictionaryAttributesKey;
OBJC_EXTERN ZYJOSSXMLDictionaryAttributeName const ZYJOSSXMLDictionaryCommentsKey;
OBJC_EXTERN ZYJOSSXMLDictionaryAttributeName const ZYJOSSXMLDictionaryTextKey;
OBJC_EXTERN ZYJOSSXMLDictionaryAttributeName const ZYJOSSXMLDictionaryNodeNameKey;
OBJC_EXTERN ZYJOSSXMLDictionaryAttributeName const ZYJOSSXMLDictionaryAttributePrefix;

OBJC_EXTERN NSString * const ZYJOSSHTTPMethodHEAD;
OBJC_EXTERN NSString * const ZYJOSSHTTPMethodGET;
OBJC_EXTERN NSString * const ZYJOSSHTTPMethodPUT;
OBJC_EXTERN NSString * const ZYJOSSHTTPMethodPOST;
OBJC_EXTERN NSString * const ZYJOSSHTTPMethodDELETE;


NS_ASSUME_NONNULL_END
