//
//  ZYJOSSCompat.h
//  ZYJOSS_ios_sdk_new
//
//  Created by zhouzhuo on 9/10/15.
//  Copyright (c) 2015 aliyun.com. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ZYJOSSService.h"

@class ZYJOSSCancellationTokenSource;

typedef ZYJOSSCancellationTokenSource ZYJOSSTaskHandler;

NS_ASSUME_NONNULL_BEGIN

@interface ZYJOSSClient (Compat)

/**
 The old version's upload API.
 Please use putObject instead.
 */
- (ZYJOSSTaskHandler *)uploadData:(NSData *)data
               withContentType:(NSString *)contentType
                withObjectMeta:(NSDictionary *)meta
                  toBucketName:(NSString *)bucketName
                   toObjectKey:(NSString *)objectKey
                   onCompleted:(void(^)(BOOL, NSError *))onCompleted
                    onProgress:(void(^)(float progress))onProgress;

/**
 The old version's download API.
 Please use getObject instead.
 */
- (ZYJOSSTaskHandler *)downloadToDataFromBucket:(NSString *)bucketName
                   objectKey:(NSString *)objectKey
                 onCompleted:(void(^)(NSData *, NSError *))onCompleted
                  onProgress:(void(^)(float progress))onProgress;

/**
 The old version's upload API.
 Please use putObject instead.
 */
- (ZYJOSSTaskHandler *)uploadFile:(NSString *)filePath
                withContentType:(NSString *)contentType
                 withObjectMeta:(NSDictionary *)meta
                   toBucketName:(NSString *)bucketName
                    toObjectKey:(NSString *)objectKey
                    onCompleted:(void(^)(BOOL, NSError *))onCompleted
                     onProgress:(void(^)(float progress))onProgress;

/**
 The old version's download API.
 Please use getObject instead.
 */
- (ZYJOSSTaskHandler *)downloadToFileFromBucket:(NSString *)bucketName
                  objectKey:(NSString *)objectKey
                     toFile:(NSString *)filePath
                onCompleted:(void(^)(BOOL, NSError *))onCompleted
                 onProgress:(void(^)(float progress))onProgress;


/**
 The old version's upload API with resumable upload support.
 Please use resumableUpload instead.
 */
- (ZYJOSSTaskHandler *)resumableUploadFile:(NSString *)filePath
          withContentType:(NSString *)contentType
           withObjectMeta:(NSDictionary *)meta
             toBucketName:(NSString *)bucketName
              toObjectKey:(NSString *)objectKey
              onCompleted:(void(^)(BOOL, NSError *))onCompleted
               onProgress:(void(^)(float progress))onProgress;

/**
 The old version's delete API.
 Please use deleteObject instead.
 */
- (void)deleteObjectInBucket:(NSString *)bucketName
                   objectKey:(NSString *)objectKey
                 onCompleted:(void(^)(BOOL, NSError *))onCompleted;
@end

NS_ASSUME_NONNULL_END
