//
//  ZYJOSSAllRequestNeededMessage.m
//  AliyunZYJOSSSDK
//
//  Created by huaixu on 2018/1/22.
//  Copyright © 2018年 aliyun. All rights reserved.
//

#import "ZYJOSSAllRequestNeededMessage.h"

#import "ZYJOSSDefine.h"
#import "ZYJOSSUtil.h"

@implementation ZYJOSSAllRequestNeededMessage

- (instancetype)init
{
    self = [super init];
    if (self) {
        _date = [[NSDate ZYJOSS_clockSkewFixedDate] ZYJOSS_asStringValue];
        _headerParams = [NSMutableDictionary dictionary];
    }
    return self;
}

- (void)setHeaderParams:(NSMutableDictionary *)headerParams {
    if (!headerParams || [headerParams isEqualToDictionary:_headerParams]) {
        return;
    }
    _headerParams = [headerParams mutableCopy];
}

- (ZYJOSSTask *)validateRequestParamsInOperationType:(ZYJOSSOperationType)operType {
    NSString * errorMessage = nil;
    
    if (!self.endpoint) {
        errorMessage = @"Endpoint should not be nil";
    }
    
    if (!self.bucketName && operType != ZYJOSSOperationTypeGetService) {
        errorMessage = @"Bucket name should not be nil";
    }
    
    if (self.bucketName && ![ZYJOSSUtil validateBucketName:self.bucketName]) {
        errorMessage = @"Bucket name invalid";
    }
    
    if (!self.objectKey &&
        (operType != ZYJOSSOperationTypeGetBucket && operType != ZYJOSSOperationTypeCreateBucket
         && operType != ZYJOSSOperationTypeDeleteBucket && operType != ZYJOSSOperationTypeGetService
         && operType != ZYJOSSOperationTypeGetBucketACL&& operType != ZYJOSSOperationTypeDeleteMultipleObjects
         && operType != ZYJOSSOperationTypeListMultipartUploads
         && operType != ZYJOSSOperationTypeGetBucketInfo)) {
            errorMessage = @"Object key should not be nil";
        }
    
    
    
    if (self.objectKey && ![ZYJOSSUtil validateObjectKey:self.objectKey]) {
        errorMessage = @"Object key invalid";
    }
    
    if (errorMessage) {
        return [ZYJOSSTask taskWithError:[NSError errorWithDomain:ZYJOSSClientErrorDomain
                                                          code:ZYJOSSClientErrorCodeInvalidArgument
                                                      userInfo:@{ZYJOSSErrorMessageTOKEN: errorMessage}]];
    } else {
        return [ZYJOSSTask taskWithResult:nil];
    }
}

@end
