//
//  NSDate+ZYJOSS.m
//  AliyunZYJOSSSDK
//
//  Created by huaixu on 2018/7/31.
//  Copyright © 2018年 aliyun. All rights reserved.
//

#import "NSDate+ZYJOSS.h"

@implementation NSDate (ZYJOSS)

NSString * const ZYJserverReturnDateFormat = @"EEE, dd MMM yyyy HH:mm:ss z";

static NSTimeInterval _clockSkew = 0.0;

+ (void)ZYJOSS_setClockSkew:(NSTimeInterval)clockSkew {
    @synchronized(self) {
        _clockSkew = clockSkew;
    }
}

+ (NSDate *)ZYJOSS_clockSkewFixedDate {
    NSTimeInterval skew = 0.0;
    @synchronized(self) {
        skew = _clockSkew;
    }
    return [[NSDate date] dateByAddingTimeInterval:(-1 * skew)];
}

+ (NSDate *)ZYJOSS_dateFromString:(NSString *)string {
    NSDateFormatter *dateFormatter = [NSDateFormatter new];
    dateFormatter.timeZone = [NSTimeZone timeZoneWithName:@"GMT"];
    dateFormatter.locale = [NSLocale localeWithLocaleIdentifier:@"en_US"];
    dateFormatter.dateFormat = ZYJserverReturnDateFormat;
    
    return [dateFormatter dateFromString:string];
}

- (NSString *)ZYJOSS_asStringValue {
    NSDateFormatter *dateFormatter = [NSDateFormatter new];
    dateFormatter.timeZone = [NSTimeZone timeZoneWithName:@"GMT"];
    dateFormatter.locale = [NSLocale localeWithLocaleIdentifier:@"en_US"];
    dateFormatter.dateFormat = ZYJserverReturnDateFormat;
    
    return [dateFormatter stringFromDate:self];
}

@end
