//
//  OffcnZYJFMDBHandler.h
//  OffcnIMSDKiOS
//
//  Created by vockey on 2019/4/9.
//  Copyright © 2019年 中公教育. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ZYJZYJFMDB.h"

@interface FMDBSensitiveWordsModel: NSObject
@property (nonatomic,copy) NSString *wordsBase64;
@property (nonatomic,copy) NSString *originalWords;
@end


//获取数据库中历史消息记录
typedef void (^getFMDBHistoryMessagesBlock)(NSArray *messagesArray);

typedef void (^callBackIsSuccess)(BOOL isSuccess);

@interface OffcnZYJFMDBHandler : NSObject

@property (nonatomic,strong) ZYJZYJFMDatabaseQueue *database;

@property (nonatomic,strong) ZYJZYJFMDatabaseQueue *gongGaoDataBase;

+ (OffcnZYJFMDBHandler *)sharedInstance;

//获取用户聊天数据库
- (void)getUserDBWithItemSqlitePath:(NSString *)itemSqlitePath;

/**
 查询聊天记录(time正叙排序)
 
 @param time 从第几秒开始查询
 @param limit 时间范围
 @param messagesBack callback
 */
- (void)getChatInfoArrayWithTime:(NSString *)time limit:(NSString *)limit callback :(getFMDBHistoryMessagesBlock)messagesBack;

/**
 查询聊天记录(seek获取当前时间之前的)

 @param time 从第几秒开始查询
 @param limit 时间范围
 @param messagesBack callback
 */
- (void)getChatInfoArrayFromTime:(NSString *)time limit:(NSString *)limit callback :(getFMDBHistoryMessagesBlock)messagesBack;

/**
 查询所有聊天记录(time正叙排序)
 
 @param messagesBack callback
 */
- (void)getChatInfoAllDataArrayCallback:(getFMDBHistoryMessagesBlock)messagesBack;

//公告
- (void)getUserGongGaoDBWithItemSqlitePath:(NSString *)itemSqlitePath;
- (void)getGongGaoArrayWithTime:(NSString *)time limit:(NSString *)limit callback :(getFMDBHistoryMessagesBlock)messagesBack;
- (void)getGongGaoArrayFromTime:(NSString *)time limit:(NSString *)limit callback :(getFMDBHistoryMessagesBlock)messagesBack;
- (void)getGongGaoAllDataArrayCallback:(getFMDBHistoryMessagesBlock)messagesBack;

//聊天本地数据库
-(void)createChatDB;
-(void)deleteSensitiveWordsDataTable;
-(void)updateSensitiveWords:(FMDBSensitiveWordsModel *)model callBack:(callBackIsSuccess)isSuccess;
-(void)getSensitiveWordsArrayWithWordsBase64:(NSString *)wordsBase64 callback:(getFMDBHistoryMessagesBlock)messagesBack;
@end

