//
//  OffcnNetworkExecutor.m
//  OffcnIMSDKiOS
//
//  Created by vockey on 2018/7/25.
//  Copyright © 2018年 中公教育. All rights reserved.
//

#import "OffcnNetworkExecutor.h"
#import "DataSafe.h"
#import "SDConfigrationNetwork.h"

@implementation OffcnNetworkExecutor
+ (void)cancelAllOperations{
    [[OffcnBaseNetworking sharedInstance] cancelAllOperations];
}

//sendAsynchronousRequest
+ (void)requesImgJsonWithUrlStr:(NSString *)urlStr Finished:(void(^)(BOOL success,id response,NSString *message))finished{

    NSURL *url = [NSURL URLWithString:urlStr];
    NSURLRequest *request = [NSURLRequest requestWithURL:url];
    [NSURLConnection sendAsynchronousRequest:request queue:[NSOperationQueue mainQueue]  completionHandler:^(NSURLResponse * _Nullable response, NSData * _Nullable data, NSError * _Nullable connectionError) {

        if (!connectionError) {
            if (!data) {
                data = [NSData data];
            }
            NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingMutableContainers error:nil];
            finished(YES,dic,nil);
        }else{
            finished(NO,nil,connectionError.localizedDescription);
        }
    }];
}

//发送消息
+ (void)requestSendMsgWithMsg_fromID:(NSString *)msg_fromID msg_toID:(NSString *)msg_toID msg_type:(NSInteger)msg_type msg:(NSMutableDictionary *)msgDic Finished:(void(^)(BOOL success,id response,BaseResponse *baseResponse))finished{

    NSMutableDictionary *dic = [NSMutableDictionary dictionary];
    [dic setObjectOnSafe:msg_fromID forKey:@"msg_from"];
    [dic setObjectOnSafe:msg_toID forKey:@"msg_to"];
    [dic setObjectOnSafe:[NSNumber numberWithInteger:msg_type] forKey:@"msg_type"];
    [dic setObjectOnSafe:msgDic forKey:@"msg"];

    [OffcnBaseNetworking postToURL:sendMsgURL bodyParams:dic finished:^(BaseResponse *baseResponse) {
        if (baseResponse.isSuccess) {

            finished(YES,baseResponse.responseObject,nil);
        }else{

            finished(NO,nil,baseResponse);
        }
    }];
}

//用户信息标记已读
+ (void)requestMarkMsgReadWithMsg_fromID:(NSString *)msg_fromID msg_toID:(NSString *)msg_toID Finished:(void(^)(BOOL success,id response,BaseResponse *baseResponse))finished{

    NSMutableDictionary *dic = [NSMutableDictionary dictionary];
    [dic setObjectOnSafe:msg_fromID forKey:@"msg_from"];
    [dic setObjectOnSafe:msg_toID forKey:@"msg_to"];

    [OffcnBaseNetworking postToURL:markMsgReadURL bodyParams:dic finished:^(BaseResponse *baseResponse) {
        if (baseResponse.isSuccess) {

            finished(YES,baseResponse.responseObject,nil);
        }else{

            finished(NO,nil,baseResponse);
        }
    }];
}


//{
//    "msg_list" =     (
//                {
//            msg =             {
//                msg = "\U6211\U662f\U4e00\U53ea\U5c0f\U9752\U9f99";
//            };
//            "msg_from" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_id" = "13e266f3-e139-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597744585;
//            "msg_to" = jfdfjei0343;
//            "msg_type" = 1;
//            "send_time" = "2020-08-18 17:56:25";
//        },
//                {
//            msg =             {
//                msg = "\U6211\U662f\U4e00\U53ea\U5c0f\U9752\U9f99";
//            };
//            "msg_from" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_id" = "85eb12d1-e13b-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597745635;
//            "msg_to" = jfdfjei0343;
//            "msg_type" = 1;
//            "send_time" = "2020-08-18 18:13:55";
//        }
//    );
//}

//获取会话未读消息列表
+ (void)requestGetSessionUnreadMsgWithFromID:(NSString *)fromID toID:(NSString *)toID Finished:(void(^)(BOOL success,id response,BaseResponse *baseResponse))finished{

    NSString *url = [NSString stringWithFormat:@"%@?from=%@&to=%@",getSessionUnreadMsgURL,fromID,toID];
    [OffcnBaseNetworking getFromURL:url params:nil finished:^(BaseResponse *baseResponse) {
        if (baseResponse.isSuccess) {
            finished(YES,baseResponse.responseObject,nil);
        }else{
            finished(NO,nil,baseResponse);
        }
    }];
}


//{
//    sessions =     (
//                {
//            "last_msg" =             {
//                "msg_content" =                 {
//                    msg = "\U6211\U662f\U4e00\U53ea\U5c0f\U9752\U9f99";
//                };
//                "msg_type" = 1;
//                "send_time" = "2020-08-18 17:48:09";
//            };
//            "session_id" = "a05517f0-ddec-11ea-88a4-4a5555fb6ab4";
//            to = jfdfjei0343;
//            type = 1;
//            "unread_number" = 11;
//        },
//                {
//            "last_msg" =             {
//                "msg_content" =                 {
//                    msg = 94563;
//                };
//                "msg_type" = 1;
//                "send_time" = "2020-08-17 13:44:47";
//            };
//            "session_id" = "a4cccd4e-e04c-11ea-88a4-4a5555fb6ab4";
//            to = 11;
//            type = 1;
//            "unread_number" = 2;
//        },
//                {
//            "last_msg" =             {
//                "msg_content" =                 {
//                    msg = "\U4f60\U597d";
//                };
//                "msg_type" = 1;
//                "send_time" = "2020-08-14 13:11:36";
//            };
//            "session_id" = "a0650499-ddec-11ea-88a4-4a5555fb6ab4";
//            to = jfdfjei0343;
//            type = 1;
//            "unread_number" = 1;
//        },
//                {
//            "last_msg" =             {
//                "msg_content" =                 {
//                    msg = "\U4f60\U597d";
//                };
//                "msg_type" = 1;
//                "send_time" = "2020-08-14 13:11:36";
//            };
//            "session_id" = "a082dc37-ddec-11ea-88a4-4a5555fb6ab4";
//            to = jfdfjei0343;
//            type = 1;
//            "unread_number" = 1;
//        },
//                {
//            "last_msg" =             {
//                "msg_content" =                 {
//                    msg = "\U4f60\U597d";
//                };
//                "msg_type" = 1;
//                "send_time" = "2020-08-14 13:11:37";
//            };
//            "session_id" = "a073155b-ddec-11ea-88a4-4a5555fb6ab4";
//            to = jfdfjei0343;
//            type = 1;
//            "unread_number" = 1;
//        },
//                {
//            "last_msg" =             {
//                "msg_content" =                 {
//                    msg = "\U4f60\U597d";
//                };
//                "msg_type" = 1;
//                "send_time" = "2020-08-14 13:11:37";
//            };
//            "session_id" = "a073b3a6-ddec-11ea-88a4-4a5555fb6ab4";
//            to = jfdfjei0343;
//            type = 1;
//            "unread_number" = 1;
//        }
//    );
//}

//获取用户最近会话记录
+ (void)requestGetRecentSessionsWithAccid:(NSString *)accid Finished:(void(^)(BOOL success,id response,BaseResponse *baseResponse))finished{

    NSString *url = [NSString stringWithFormat:@"%@?accid=%@",getRecentSessionsURL,accid];
    [OffcnBaseNetworking getFromURL:url params:nil finished:^(BaseResponse *baseResponse) {
        if (baseResponse.isSuccess) {
            finished(YES,baseResponse.responseObject,nil);
        }else{
            finished(NO,nil,baseResponse);
        }
    }];
}

//获取会话历史消息列表
+ (void)requestGetSessionHistoryMsgWithFromID:(NSString *)fromID toID:(NSString *)toID msg_seq:(NSString *)msg_seq Finished:(void(^)(BOOL success,id response,BaseResponse *baseResponse))finished{

    NSString *url = [NSString stringWithFormat:@"%@?from=%@&to=%@&msg_seq=%@",getSessionHistoryMsgURL,fromID,toID,msg_seq];
    [OffcnBaseNetworking getFromURL:url params:nil finished:^(BaseResponse *baseResponse) {
        if (baseResponse.isSuccess) {
            finished(YES,baseResponse.responseObject,nil);
        }else{
            finished(NO,nil,baseResponse);
        }
    }];
}

//获取七牛Token
+ (void)requestUploadTokenFinished:(void(^)(BOOL success,id response,BaseResponse *baseResponse))finished{

    [OffcnBaseNetworking getFromURL:uploadToken params:nil finished:^(BaseResponse *baseResponse) {
        if (baseResponse.isSuccess) {
            finished(YES,baseResponse.responseObject,nil);
        }else{
            finished(NO,nil,baseResponse);
        }
    }];
}

//注册用户设备
+ (void)requestRegisterDevicesWithAccid:(NSString *)accid device_token:(NSString *)device_token Finished:(void(^)(BOOL success,id response,BaseResponse *baseResponse))finished{

    NSMutableDictionary *dic = [NSMutableDictionary dictionary];
    [dic setObjectOnSafe:accid forKey:@"accid"];
    [dic setObjectOnSafe:@"ios" forKey:@"device"];
    [dic setObjectOnSafe:device_token forKey:@"device_token"];

    [OffcnBaseNetworking postToURL:registerDevices bodyParams:dic finished:^(BaseResponse *baseResponse) {
        if (baseResponse.isSuccess) {

            finished(YES,baseResponse.responseObject,nil);
        }else{

            finished(NO,nil,baseResponse);
        }
    }];
}

//注销用户设备
+ (void)requestUnregisterDevicesWithAccid:(NSString *)accid device_token:(NSString *)device_token Finished:(void(^)(BOOL success,id response,BaseResponse *baseResponse))finished{

    NSMutableDictionary *dic = [NSMutableDictionary dictionary];
    [dic setObjectOnSafe:accid forKey:@"accid"];
    [dic setObjectOnSafe:@"ios" forKey:@"device"];
    [dic setObjectOnSafe:device_token forKey:@"device_token"];

    [OffcnBaseNetworking postToURL:unregisterDevices bodyParams:dic finished:^(BaseResponse *baseResponse) {
        if (baseResponse.isSuccess) {

            finished(YES,baseResponse.responseObject,nil);
        }else{

            finished(NO,nil,baseResponse);
        }
    }];
}

@end

//{
//    "msg_list" =     (
//                {
//            msg =             {
//                msg = "\U4f60\U597d";
//            };
//            "msg_from" = jfdfjei0343;
//            "msg_id" = "a0c76912-ddec-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597381897;
//            "msg_to" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_type" = 1;
//            "send_time" = "2020-08-14 13:11:36";
//        },
//                {
//            msg =             {
//                msg = 8025;
//            };
//            "msg_from" = jfdfjei0343;
//            "msg_id" = "f9ed87ec-e04f-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597644468;
//            "msg_to" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_type" = 1;
//            "send_time" = "2020-08-17 14:07:48";
//        },
//                {
//            msg =             {
//                msg = 83443;
//            };
//            "msg_from" = jfdfjei0343;
//            "msg_id" = "07a48919-e053-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597645780;
//            "msg_to" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_type" = 1;
//            "send_time" = "2020-08-17 14:29:40";
//        },
//                {
//            msg =             {
//                msg = 43394;
//            };
//            "msg_from" = jfdfjei0343;
//            "msg_id" = "1b450a3d-e053-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597645813;
//            "msg_to" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_type" = 1;
//            "send_time" = "2020-08-17 14:30:13";
//        },
//                {
//            msg =             {
//                msg = 43887;
//            };
//            "msg_from" = jfdfjei0343;
//            "msg_id" = "221b33cc-e053-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597645824;
//            "msg_to" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_type" = 1;
//            "send_time" = "2020-08-17 14:30:24";
//        },
//                {
//            msg =             {
//                msg = 84730;
//            };
//            "msg_from" = jfdfjei0343;
//            "msg_id" = "4bf86940-e053-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597645895;
//            "msg_to" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_type" = 1;
//            "send_time" = "2020-08-17 14:31:34";
//        },
//                {
//            msg =             {
//                msg = 29875;
//            };
//            "msg_from" = jfdfjei0343;
//            "msg_id" = "4efc6485-e053-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597645900;
//            "msg_to" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_type" = 1;
//            "send_time" = "2020-08-17 14:31:40";
//        },
//                {
//            msg =             {
//                msg = 15702;
//            };
//            "msg_from" = jfdfjei0343;
//            "msg_id" = "1cc40899-e055-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597646674;
//            "msg_to" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_type" = 1;
//            "send_time" = "2020-08-17 14:44:34";
//        },
//                {
//            msg =             {
//                msg = 71562;
//            };
//            "msg_from" = jfdfjei0343;
//            "msg_id" = "d4b1a5ec-e05b-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597649560;
//            "msg_to" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_type" = 1;
//            "send_time" = "2020-08-17 15:32:40";
//        },
//                {
//            msg =             {
//                msg = 9505;
//            };
//            "msg_from" = jfdfjei0343;
//            "msg_id" = "cc398ec9-e05c-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597649975;
//            "msg_to" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_type" = 1;
//            "send_time" = "2020-08-17 15:39:35";
//        },
//                {
//            msg =             {
//                msg = 26136;
//            };
//            "msg_from" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_id" = "ecf62e44-e05e-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597650889;
//            "msg_to" = jfdfjei0343;
//            "msg_type" = 1;
//            "send_time" = "2020-08-17 15:54:49";
//        },
//                {
//            msg =             {
//                msg = 51775;
//            };
//            "msg_from" = jfdfjei0343;
//            "msg_id" = "289fefdb-e05f-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597650989;
//            "msg_to" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_type" = 1;
//            "send_time" = "2020-08-17 15:56:29";
//        },
//                {
//            msg =             {
//                msg = 22159;
//            };
//            "msg_from" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_id" = "2fb43160-e0f0-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597713278;
//            "msg_to" = jfdfjei0343;
//            "msg_type" = 1;
//            "send_time" = "2020-08-18 09:14:38";
//        },
//                {
//            msg =             {
//                msg = "\U6211\U662f\U4e00\U53ea\U5c0f\U9752\U9f99";
//            };
//            "msg_from" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_id" = "31bcd9c7-e137-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597743776;
//            "msg_to" = jfdfjei0343;
//            "msg_type" = 1;
//            "send_time" = "2020-08-18 17:42:56";
//        },
//                {
//            msg =             {
//                msg = "\U6211\U662f\U4e00\U53ea\U5c0f\U9752\U9f99";
//            };
//            "msg_from" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_id" = "ec318df1-e137-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597744089;
//            "msg_to" = jfdfjei0343;
//            "msg_type" = 1;
//            "send_time" = "2020-08-18 17:48:09";
//        },
//                {
//            msg =             {
//                msg = "\U6211\U662f\U4e00\U53ea\U5c0f\U9752\U9f99";
//            };
//            "msg_from" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_id" = "895e2cbc-e138-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597744353;
//            "msg_to" = jfdfjei0343;
//            "msg_type" = 1;
//            "send_time" = "2020-08-18 17:52:32";
//        },
//                {
//            msg =             {
//                msg = "\U6211\U662f\U4e00\U53ea\U5c0f\U9752\U9f99";
//            };
//            "msg_from" = ce0819db8391f1e7258a71cc9e2c3235;
//            "msg_id" = "dda56169-e138-11ea-88a4-4a5555fb6ab4";
//            "msg_seq" = 1597744494;
//            "msg_to" = jfdfjei0343;
//            "msg_type" = 1;
//            "send_time" = "2020-08-18 17:54:54";
//        }
//    );
//}
