//
//  OffcnBaseNetworking.h
//  OffcnIMSDKiOS
//
//  Created by vockey on 2018/7/25.
//  Copyright © 2018年 中公教育. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ZYJAFNetworking.h"

@class BaseResponse;

//token 失效的code
//static NSInteger const KtokenCode = 401;
//无网的code（此code为自定义）
static NSInteger const KNoNetWorkCode = 20170109;

typedef void(^NetworkCallBack)(BaseResponse * baseResponse);


@interface OffcnBaseNetworking : NSObject

@property(strong, nonatomic) ZYJAFHTTPSessionManager *manager;

//需要对接传入参数serviceType；httpHeaderDic
/// 设置默认服务器 1为开发服务器, 2为测试服务器, 3为正式服务器
@property (nonatomic , assign)NSInteger serviceType;

//登陆后获取的token
@property (nonatomic , copy)NSString *token;
@property (nonatomic , copy)NSString *imageBaseUrl;

@property (nonatomic , strong)NSDictionary *httpHeaderDic;

+ (instancetype)sharedInstance;

+ (void)configureHttpHeaderWithDict:(NSDictionary *)dict;

+(NSString *)get_BASEURL;
//图片服务器
+(NSString *)get_ImageBaseUrl;
//h5服务器
+(NSString *)get_h5live;
//call_server_topic服务器
+(NSString *)get_call_server_topic;


+ (void)getFromURL:(NSString *)URLString
            params:(NSDictionary *)params
          finished:(NetworkCallBack)finished;

+ (void)postToURL:(NSString *)URLString
       bodyParams:(id)bodyParams
         finished:(NetworkCallBack)finished;

+ (void)putToURL:(NSString *)URLString
      bodyParams:(id)bodyParams
        finished:(NetworkCallBack)finished;

+ (void)deleteToURL:(NSString *)URLString
         bodyParams:(id)bodyParams
           finished:(NetworkCallBack)finished;
/**
 *  取消去全部
 */
- (void)cancelAllOperations;
//上传图片
//+ (void)getImgurl:(NSString *)url imgArr:(NSMutableArray *)imgArr index:(NSInteger)index finished:(NetworkCallBack)finished;

@end

@interface BaseResponse : NSObject

///返回的httpCode
@property (assign,nonatomic) NSInteger httpCode;

@property (assign,nonatomic) NSInteger code;
///返回的错误信息
@property (copy,nonatomic) NSString *errorMessage;
///是否成功
@property (assign) BOOL isSuccess;
@property(copy, nonatomic) NSString *url;//请求url
@property (nonatomic) id responseObject;
@property (nonatomic,strong) NSError *error;
@property (nonatomic, strong) NSURLSessionDataTask *task;
- (instancetype)initWithTask:(NSURLSessionDataTask *)task responseObject :(id)responseObject error :(NSError *) error;
-(BaseResponse *)checkNotReachability;


@end
