//
//  SDTool.m
//  HomeHealth
//
//  Created by newuser on 17/1/4.
//  Copyright © 2017年 ChiJian. All rights reserved.
//

#import "SDTool.h"
#import "CJLoadingView.h"
#import "ZYJRealReachability.h"
#import "ZYJMBProgressHUD.h"
#import "SDGeneralDefine.h"

@interface SDTool ()

@property (strong,nonatomic)UIActivityIndicatorView *indicatorView;

@property (strong,nonatomic)CJLoadingView *loadingView;

@end


@implementation SDTool

+(instancetype)instance{
    static SDTool *tl = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        tl = [[SDTool alloc]init];
    });
    return tl;
}

-(UIActivityIndicatorView *)indicatorView{
    if (!_indicatorView) {
        _indicatorView = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleGray];
        _indicatorView.frame = KKeyWindow.bounds;
    }
    return _indicatorView;
}

-(CJLoadingView *)loadingView{
    if (!_loadingView) {
        _loadingView = [[CJLoadingView alloc] initWithFrame:KKeyWindow.bounds];
    }
    return _loadingView;
}

+ (void)showHUDWithText:(NSString *)text
{
    if ([text length]<=0) {
        return;
    }
    [SDTool showWarning:KKeyWindow mText:text seconds:2.0 callback:nil];
}

+ (void)showHUDWithText:(NSString *)text callback:(void(^)(void))callback
{
    [SDTool showWarning:KKeyWindow mText:text seconds:2.0 callback:callback];
}

+ (void)showHUDWithTextAndNotNoMessage:(NSString *)text{
    if (text && [text respondsToSelector:@selector(length)] &&text.length && ![text isEqualToString:@"请求失败"]) {
        [SDTool showHUDWithText:text];
    }
}

+(void)showWarning:(UIView *)view mText:(NSString *)text seconds:(CGFloat)seconds callback:(void(^)(void))hudCallBack{
    
    ZYJMBProgressHUD *hud = [ZYJMBProgressHUD showHUDAddedTo:view animated:YES];
    
    NSMutableParagraphStyle *pStyle = [[NSMutableParagraphStyle alloc]init];
    [pStyle setLineSpacing:0.5];
    [pStyle setLineBreakMode:NSLineBreakByWordWrapping];
    CGRect matchRect = [text boundingRectWithSize:CGSizeMake(190, 150) options:NSStringDrawingUsesLineFragmentOrigin attributes:[NSDictionary dictionaryWithObjectsAndKeys:KFontNameMediumSize(13),NSFontAttributeName,pStyle,NSParagraphStyleAttributeName, nil] context:nil];
    
    hud.mode = ZYJMBProgressHUDModeCustomView;
    UILabel *mLabel = [[UILabel alloc]initWithFrame:CGRectMake(0, 0, matchRect.size.width, matchRect.size.height)];
    mLabel.backgroundColor = [UIColor clearColor];
    mLabel.textColor = [UIColor whiteColor];
    mLabel.font = KFontNameMediumSize(13);
    mLabel.textAlignment = NSTextAlignmentCenter;
    mLabel.lineBreakMode = NSLineBreakByWordWrapping;
    mLabel.numberOfLines = 0;
    mLabel.text = text;
    hud.customView = mLabel;
    hud.bezelView.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.6];
    if (hudCallBack) {
        hud.completionBlock = [hudCallBack copy];
    }

    [hud hideAnimated:YES afterDelay:seconds];
}
+ (void)showHUDCustomSucceesWithText:(NSString *)text
{
    if ([text length]<=0) {
        return;
    }
    [SDTool showCustomSuccees:KKeyWindow mText:text seconds:2.0 callback:nil];
}
+(void)showCustomSuccees:(UIView *)view mText:(NSString *)text seconds:(CGFloat)seconds callback:(void(^)(void))hudCallBack{
    
    ZYJMBProgressHUD *hud = [ZYJMBProgressHUD showHUDAddedTo:view animated:YES];
    
    hud.mode = ZYJMBProgressHUDModeCustomView;
    hud.customView = [[UIImageView alloc] initWithImage:KImageNamed(@"SDVideo_tiJiaoChengGong")];
    
    hud.label.text = text;
    hud.label.textColor = [UIColor whiteColor];
    hud.label.font = KFontNameMediumSize(13);
    
    hud.bezelView.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.6];
    if (hudCallBack) {
        hud.completionBlock = [hudCallBack copy];
    }
    [hud hideAnimated:YES afterDelay:seconds];
}
+(void)showLoadingOnView:(UIView *)view{
    [SDTool instance].indicatorView.frame = view.bounds;
    [view addSubview:[SDTool instance].indicatorView];
    [[SDTool instance].indicatorView startAnimating];
    
//    [SDTool instance].loadingView.frame = view.bounds;
//    [view addSubview:[SDTool instance].loadingView];
//    [[SDTool instance].loadingView startAnimation];

}

+(void)showLoadingOnWindowCustomFrame:(CGRect)frame{
    [SDTool instance].indicatorView.frame = frame;
    [KKeyWindow addSubview:[SDTool instance].indicatorView];
    [[SDTool instance].indicatorView startAnimating];
    
//    [SDTool instance].loadingView.frame = frame;
//    [KKeyWindow addSubview:[SDTool instance].loadingView];
//    [[SDTool instance].loadingView startAnimation];

}

+(void)showLoadingOnWindow{
    [SDTool instance].indicatorView.frame = [UIScreen mainScreen].bounds;
    [KKeyWindow addSubview:[SDTool instance].indicatorView];
    [[SDTool instance].indicatorView startAnimating];
    
//    [SDTool instance].loadingView.frame = [UIScreen mainScreen].bounds;
//    [KKeyWindow addSubview:[SDTool instance].loadingView];
//    [[SDTool instance].loadingView startAnimation];

}


+(void)hideLoading{
    [[SDTool instance].indicatorView stopAnimating];
    [[SDTool instance].indicatorView removeFromSuperview];
    
//    [[SDTool instance].loadingView removeFromSuperview];
//    [[SDTool instance].loadingView stopAnimation];

}

+ (void)callPhone:(NSString *)phoneNum{

    UIAlertView* alertView = [[UIAlertView alloc] initWithTitle:phoneNum message:@"" delegate:[SDTool instance] cancelButtonTitle:@"取消" otherButtonTitles:@"确定", nil];
    alertView.tag = 10086;
    [alertView show];

//    NSMutableString* str=[[NSMutableString alloc] initWithFormat:@"telprompt://%@",phoneNum];
//    // NSLog(@"str======%@",str);
//    [[UIApplication sharedApplication] openURL:[NSURL URLWithString:str]];
}

- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex {
    if (buttonIndex == 1 && alertView.tag == 10086) {
        NSURL *phoneURL = [NSURL URLWithString:[NSString stringWithFormat:@"tel://%@",alertView.title]];
        [[UIApplication sharedApplication] openURL:phoneURL];
    }
}

+ (BOOL)isExistenceNetwork
{
    BOOL isExistenceNetwork = false;
    ReachabilityStatus status = [GLobalRealReachability currentReachabilityStatus];
    NSLog(@"Initial reachability status:%@",@(status));
    
    if (status == RealStatusNotReachable)
    {
        isExistenceNetwork = false;
    }
    
    if (status == RealStatusViaWiFi)
    {
        isExistenceNetwork = true;
    }
    
    if (status == RealStatusViaWWAN)
    {
        isExistenceNetwork = true;
    }
    return isExistenceNetwork;
}
//设置状态栏颜色
//+ (void)setStatusBarBackgroundColor:(UIColor *)color{
//    [[UIApplication sharedApplication] setStatusBarHidden:NO withAnimation:UIStatusBarAnimationNone];
//    UIView *statusBar = [[[UIApplication sharedApplication] valueForKey:@"statusBarWindow"] valueForKey:@"statusBar"];
//    if ([statusBar respondsToSelector:@selector(setBackgroundColor:)]) {
//        statusBar.backgroundColor = color;
//    }
//}
@end
