//
//  UIViewController+SDIphoneX.m
//  OffcnLiveSDK
//
//  Created by vockey on 2018/8/16.
//  Copyright © 2018年 中公教育. All rights reserved.
//

#import "UIViewController+SDIphoneX.h"
#import "ZYJMasonry.h"
#import "UIViewExt.h"
#import "SDGeneralDefine.h"

@implementation UIViewController (SDIphoneX)

-(void)fixIphoneStatusBar{
    UIView *statusBarBackView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreen_Width, KStatusBarHeight)];
    statusBarBackView.backgroundColor = [UIColor blackColor];
    statusBarBackView.tag = 44;
    [self.view addSubview:statusBarBackView];
    [statusBarBackView mas_makeConstraints:^(ZYJMASConstraintMaker *make) {
        make.top.leading.trailing.equalTo(self.view);
        make.height.mas_equalTo(KStatusBarHeight);
    }];
}

-(void)fixIphoneXBottom{
    if (kIsIphoneX) {
        UIView *bottomView = [[UIView alloc] initWithFrame:CGRectMake(0, self.view.height - 34, kScreen_Width, 34)];
        bottomView.backgroundColor = [UIColor whiteColor];
        bottomView.tag = 34;
        [self.view addSubview:bottomView];
        [bottomView mas_makeConstraints:^(ZYJMASConstraintMaker *make) {
            make.bottom.leading.trailing.equalTo(self.view);
            make.height.mas_equalTo(34);
        }];
    }
}

//是否含有刘海 即是否为X XS XS Max XR
-(BOOL)isHasFringe{
    CGFloat iPhoneNotchDirectionSafeAreaInsets = 0;
    if (iOS11) {
        UIEdgeInsets safeAreaInsets = [UIApplication sharedApplication].windows[0].safeAreaInsets;
        switch ([UIApplication sharedApplication].statusBarOrientation) {
            case UIInterfaceOrientationPortrait:{
                iPhoneNotchDirectionSafeAreaInsets = safeAreaInsets.top;
            }
                break;
            case UIInterfaceOrientationLandscapeLeft:{
                iPhoneNotchDirectionSafeAreaInsets = safeAreaInsets.left;
            }
                break;
            case UIInterfaceOrientationLandscapeRight:{
                iPhoneNotchDirectionSafeAreaInsets = safeAreaInsets.right;
            }
                break;
            case UIInterfaceOrientationPortraitUpsideDown:{
                iPhoneNotchDirectionSafeAreaInsets = safeAreaInsets.bottom;
            }
                break;
            default:
                iPhoneNotchDirectionSafeAreaInsets = safeAreaInsets.top;
                break;
        }
        return iPhoneNotchDirectionSafeAreaInsets > 20;
    } else {
        return NO;
    }
}

@end
