//
//  SDButton.m
//  OffcnIMSDKiOS
//
//  Created by vockey on 2018/7/31.
//  Copyright © 2018年 中公教育. All rights reserved.
//

#import "SDButton.h"
#import "SDGeneralDefine.h"

@implementation SDButton

+ (SDButton *)initWithTitle:(NSString *)title norImage:(NSString *)norImage higImage:(NSString *)higImage targert:(id)targert action:(SEL)action{
    SDButton *btn = [[self alloc]init];
    if (norImage != nil && ![norImage isEqualToString:@""]) {
        
        [btn setImage:KImageNamed(norImage) forState:UIControlStateNormal];
    }
    if (higImage != nil && ![higImage isEqualToString:@""]) {
        
        [btn setImage:KImageNamed(higImage) forState:UIControlStateHighlighted];
    }
    if (title != nil && ![title isEqualToString:@""]) {
        
        [btn setTitle:title forState:UIControlStateNormal];
    }
    
    [btn sizeToFit];
    [btn addTarget:targert action:action forControlEvents:UIControlEventTouchUpInside];
    
    return btn;
}
+ (SDButton *)initWithTitle:(NSString *)title norImage:(NSString *)norImage higImage:(NSString *)higImage offset:(CGFloat)offset targert:(id)targert action:(SEL)action{
    
    SDButton *btn = [[self alloc] init];
    [btn setBackgroundImage:KImageNamed(@"SDVideo_tiwen_beijing") forState:UIControlStateNormal];
    if (norImage != nil && ![norImage isEqualToString:@""]) {
        
        [btn setImage:KImageNamed(norImage) forState:UIControlStateNormal];
    }
    if (higImage != nil && ![higImage isEqualToString:@""]) {
        
        [btn setImage:KImageNamed(higImage) forState:UIControlStateHighlighted];
    }
    
    [btn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    btn.titleLabel.font = KFontNameMediumSize(10);
    btn.titleLabel.textAlignment = NSTextAlignmentCenter;
    if (title != nil && ![title isEqualToString:@""]) {
        
        [btn setTitle:title forState:UIControlStateNormal];
    }
    
    btn.titleEdgeInsets = UIEdgeInsetsMake(0, -btn.imageView.intrinsicContentSize.width, -btn.imageView.intrinsicContentSize.height- offset/2.0, 0);
    btn.imageEdgeInsets = UIEdgeInsetsMake(-btn.titleLabel.intrinsicContentSize.height- offset/2.0, 0, 0, -btn.titleLabel.intrinsicContentSize.width);
    
    [btn addTarget:targert action:action forControlEvents:UIControlEventTouchUpInside];
    
    return btn;
}
+ (SDButton *)initWithNorBackgroundImage:(NSString *)norBackgroundImage higBackgroundImage:(NSString *)higBackgroundImage targert:(id)targert action:(SEL)action{
    SDButton *btn = [self buttonWithType:UIButtonTypeCustom];
    if (norBackgroundImage != nil && ![norBackgroundImage isEqualToString:@""]) {
        
        [btn setBackgroundImage:KImageNamed(norBackgroundImage) forState:UIControlStateNormal];
    }
    if (higBackgroundImage != nil && ![higBackgroundImage isEqualToString:@""]) {
        
        [btn setBackgroundImage:KImageNamed(higBackgroundImage) forState:UIControlStateSelected];
    }
    [btn sizeToFit];
    [btn addTarget:targert action:action forControlEvents:UIControlEventTouchDown];
    
    return btn;
}
@end
