//
//  JYButton.m
//  张云杰
//
//  Created by mac on 16/3/13.
//  Copyright © 2016年 com.jyall. All rights reserved.
//

#import "JYButton.h"
#import "SDGeneralDefine.h"

@implementation JYButton
+ (JYButton *)initWithTitle:(NSString *)title norImage:(NSString *)norImage higImage:(NSString *)higImage targert:(id)targert action:(SEL)action{
    JYButton *btn = [[self alloc]init];
    if (norImage != nil && ![norImage isEqualToString:@""]) {
        
        [btn setImage:KImageNamed(norImage) forState:UIControlStateNormal];
    }
    if (higImage != nil && ![higImage isEqualToString:@""]) {
        
        [btn setImage:KImageNamed(higImage) forState:UIControlStateHighlighted];
    }
    if (title != nil && ![title isEqualToString:@""]) {
        
        [btn setTitle:title forState:UIControlStateNormal];
    }
    
    [btn sizeToFit];
    [btn addTarget:targert action:action forControlEvents:UIControlEventTouchUpInside];
    
    return btn;
}
+ (JYButton *)initWithNorBackgroundImage:(NSString *)norBackgroundImage higBackgroundImage:(NSString *)higBackgroundImage targert:(id)targert action:(SEL)action{
    JYButton *btn = [self buttonWithType:UIButtonTypeCustom];
    if (norBackgroundImage != nil && ![norBackgroundImage isEqualToString:@""]) {
        
        [btn setBackgroundImage:KImageNamed(norBackgroundImage) forState:UIControlStateNormal];
    }
    if (higBackgroundImage != nil && ![higBackgroundImage isEqualToString:@""]) {
        
        [btn setBackgroundImage:KImageNamed(higBackgroundImage) forState:UIControlStateSelected];
    }
    [btn sizeToFit];
    [btn addTarget:targert action:action forControlEvents:UIControlEventTouchDown];
    
    return btn;

}
// 让按钮在高亮的状态不要做其他操作
- (void)setHighlighted:(BOOL)highlighted
{
    //[super setHighlighted:highlighted];
}

@end
