//
//  NSString+Extension.m

//
//  Created by xc on 15/3/6.
//  Copyright (c) 2015年 xc. All rights reserved.
//

#import "NSString+Extension.h"
#import "OffcnBaseNetworking.h"
#import "SDConfigrationNetwork.h"
#import "SDGeneralDefine.h"

@implementation NSString (Extension)

#pragma mark 拆成数组再获取指定字符串
- (NSString *)subStringFromStartString:(NSString *)startString withSeparatedByString:(NSString *)str{
    NSString *returnStr = @"";
    NSArray *arr = [self componentsSeparatedByString:str];
    for (int i=0; i<arr.count; i++) {
        NSString *subStr = arr[i];
        if ([subStr rangeOfString:startString].length) {
            returnStr = [subStr substringFromIndex:startString.length];
            break;
        }
    }
    return returnStr;
}

#pragma mark 截取两个字符之间字符串
- (NSString *)subStringFrom:(NSString *)startString to:(NSString *)endString{
    NSRange startRange = [self rangeOfString:startString];
    NSRange endRange = [self rangeOfString:endString];
    NSRange range = NSMakeRange(startRange.location + startRange.length, endRange.location - startRange.location - startRange.length);
    return [self substringWithRange:range];
}
#pragma mark 计算字符串大小
- (CGSize)sizeWithFont:(UIFont *)font maxSize:(CGSize)maxSize
{
    //    NSMutableParagraphStyle *paraStyle = [[NSMutableParagraphStyle alloc] init];
    //    paraStyle.lineSpacing = 6;
    
    NSDictionary *dict = @{NSFontAttributeName: font,NSKernAttributeName:@0.0f};
    CGSize textSize = [self boundingRectWithSize:maxSize options:NSStringDrawingUsesLineFragmentOrigin|NSStringDrawingUsesFontLeading attributes:dict context:nil].size;
    return textSize;
}
- (CGFloat)sizeWithFont:(UIFont *)font maxWidth:(CGFloat)maxWidth
{
    //    NSMutableParagraphStyle *paraStyle = [[NSMutableParagraphStyle alloc] init];
    //    paraStyle.lineSpacing = 6;
    //
    //    NSDictionary *dict = @{NSFontAttributeName: font,NSParagraphStyleAttributeName:paraStyle,NSKernAttributeName:@0.0f};
    NSDictionary *dict = @{NSFontAttributeName: font,NSKernAttributeName:@0.0f};
    CGSize textSize = [self boundingRectWithSize:CGSizeMake(maxWidth, 10000) options:NSStringDrawingUsesLineFragmentOrigin|NSStringDrawingUsesFontLeading  attributes:dict context:nil].size;
    return textSize.height;
}
- (NSString *)URLEncodedString{
    NSString *encodedString = (NSString *)
    CFBridgingRelease(CFURLCreateStringByAddingPercentEscapes(kCFAllocatorDefault,
                                                              (CFStringRef)self,
                                                              (CFStringRef)@"!$&'()*+,-./:;=?@_~%#[]",
                                                              NULL,
                                                              kCFStringEncodingUTF8));
    return encodedString;
}

+ (NSString *)getAddSourceAppUrl:(NSString *)url{
    NSString *retUrl;
    if ([url containsString:@"?source=app"]) {
        retUrl =  url;
    }else if ([url containsString:@"?"]){
        retUrl = [url stringByAppendingString:@"&source=app"];
    }else{
        retUrl = [url stringByAppendingString:@"?source=app"];
    }
    retUrl = [NSString CustomAddUrl:retUrl];
    return retUrl;
}
//判断是否图片链接带http。返回正确的链接
+(NSString *)isHttpImageUrl:(NSString *)imageUrl{
    
    if ([imageUrl containsString:@"http"]) {
        return imageUrl;
    }
    return [BASE_IMAGE_URL stringByAppendingString:imageUrl];
}

#pragma mark  链接新添加的
+ (NSString *)CustomAddUrl:(NSString *)url{
    
    NSString *appkeyParam = [NSString stringWithFormat:@"APPkey=%@",KCustomerAPPKEY];
    //    NSString *deviceIdParam = [NSString stringWithFormat:@"deviceid=%@",[UMSAgent getUMSUDID]];
    //    NSString *appendStr = [NSString stringWithFormat:@"%@&%@&%@",url,appkeyParam,deviceIdParam];
    //    NSString *userId = [[[CommonManager shareInstance] getAccount] userId];
    //    if ([userId length] > 0) {
    //        appendStr = [appendStr stringByAppendingFormat:@"&userId=%@",userId];
    //    }
    return appkeyParam;
}
@end
