//
//  NSMutableAttributedString+SDSize.m
//  OffcnIMSDKiOS
//
//  Created by vockey on 2018/8/23.
//  Copyright © 2018年 中公教育. All rights reserved.
//

#import "NSMutableAttributedString+SDSize.h"

@implementation NSMutableAttributedString (SDSize)

#pragma mark 计算字符串大小
- (CGSize)sizeWithMaxSize:(CGSize)maxSize
{
    CGSize textSize = [self boundingRectWithSize:maxSize options:NSStringDrawingUsesLineFragmentOrigin|NSStringDrawingUsesFontLeading context:nil].size;
    return CGSizeMake(ceilf(textSize.width), ceilf(textSize.height));
}
- (CGFloat)sizeWithMaxWidth:(CGFloat)maxWidth
{
    CGSize textSize = [self boundingRectWithSize:CGSizeMake(maxWidth, CGFLOAT_MAX) options:NSStringDrawingUsesLineFragmentOrigin|NSStringDrawingUsesFontLeading context:nil].size;
    return ceilf(textSize.height);
}
@end
