
//
//  NSAttributedString+SDSize.m
//  OffcnIMSDKiOS
//
//  Created by vockey on 2018/8/23.
//  Copyright © 2018年 中公教育. All rights reserved.
//

#import "NSAttributedString+SDSize.h"

@implementation NSAttributedString (SDSize)

#pragma mark 计算字符串大小
- (CGSize)sizeWithMaxSize:(CGSize)maxSize
{
    CGSize textSize = [self boundingRectWithSize:maxSize options:NSStringDrawingUsesLineFragmentOrigin|NSStringDrawingUsesFontLeading context:nil].size;
    return textSize;
}
- (CGFloat)sizeWithMaxWidth:(CGFloat)maxWidth
{
    CGSize textSize = [self boundingRectWithSize:CGSizeMake(maxWidth, 10000) options:NSStringDrawingUsesLineFragmentOrigin|NSStringDrawingUsesFontLeading context:nil].size;
    return textSize.height;
}
@end
