//
//  OffcnIMSDKiOS.m
//  OffcnIMSDKiOS
//
//  Created by vockey on 2018/10/16.
//  Copyright © 2018年 中公教育. All rights reserved.
//

#import "OffcnIMSDKiOS.h"
#import "OffcnBaseNetworking.h"
#import "ZYJRealReachability.h"
#import "SDGeneralDefine.h"
#import "OffcnNetworkExecutor.h"

@interface OffcnIMSDKiOS ()


@end

@implementation OffcnIMSDKiOS

static OffcnIMSDKiOS *liveTelecastSDK;
+ (OffcnIMSDKiOS *)defaultService{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        liveTelecastSDK = [[OffcnIMSDKiOS alloc] init];
    });
    return liveTelecastSDK;
}
-(void)setIsTest:(BOOL)isTest{
    if (isTest) {
        [[OffcnBaseNetworking sharedInstance] setServiceType:2];
    }else{
        [[OffcnBaseNetworking sharedInstance] setServiceType:3];
    }
    _isTest = isTest;
}
#pragma mark - 使用RealReachability监听网络状态
-(void)startNotifierUseRealReachability{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(networkChanged:)                                            name:ZYJkRealReachabilityChangedNotification object:nil];
    
    GLobalRealReachability.hostForPing = @"api.live.offcncloud.com";
    GLobalRealReachability.pingTimeout = 10;
    [GLobalRealReachability startNotifier];
    
    ReachabilityStatus status = [GLobalRealReachability currentReachabilityStatus];
    [self realNetworkingStatus:status];
}
- (void)networkChanged:(NSNotification *)notification
{
    ZYJRealReachability *reachability= (ZYJRealReachability *)notification.object;
    ReachabilityStatus status= [reachability currentReachabilityStatus];
    [self realNetworkingStatus:status];
}
-(void)realNetworkingStatus:(ReachabilityStatus)status{
    KWeakSelf
    switch (status){
        case RealStatusUnknown:
        case RealStatusNotReachable:
        {
            [OffcnNetworkExecutor requesImgJsonWithUrlStr:@"https://api.live.offcncloud.com" Finished:^(BOOL success, id response, NSString *message) {
                if (success) {
                    weakSelf.OffcnReachabilityStatus = OffcnSDKReachabilityStatusViaWiFi;
                    if (weakSelf.reachabilityStatusCallBack) {
                        weakSelf.reachabilityStatusCallBack(OffcnSDKReachabilityStatusViaWiFi);
                    }
                }else{
                    weakSelf.OffcnReachabilityStatus = OffcnSDKReachabilityStatusNotReachable;
                    if (weakSelf.reachabilityStatusCallBack) {
                        weakSelf.reachabilityStatusCallBack(OffcnSDKReachabilityStatusNotReachable);
                    }
                }
            }];
            break;
        }
        case RealStatusViaWWAN:
        {
            self.OffcnReachabilityStatus = OffcnSDKReachabilityStatusViaWWAN;
            if (self.reachabilityStatusCallBack) {
                self.reachabilityStatusCallBack(OffcnSDKReachabilityStatusViaWWAN);
            }
            break;
        }
        case RealStatusViaWiFi:
        {
            self.OffcnReachabilityStatus = OffcnSDKReachabilityStatusViaWiFi;
            if (self.reachabilityStatusCallBack) {
                self.reachabilityStatusCallBack(OffcnSDKReachabilityStatusViaWiFi);
            }
            break;
        }
        default:
            break;
    }
}

-(void)dealloc{

}

@end
