//
//  OffcnIMSDKiOS.h
//  OffcnIMSDKiOS
//
//  Created by vockey on 2018/10/16.
//  Copyright © 2018年 中公教育. All rights reserved.
//

#import <UIKit/UIKit.h>

static const NSString *OffcnIMSDKiOSVersion = @"1.0.0.0";

typedef NS_ENUM(NSUInteger, OffcnSDKReachabilityStatus) {
    OffcnSDKReachabilityStatusNotReachable = 0,
    OffcnSDKReachabilityStatusViaWWAN,
    OffcnSDKReachabilityStatusViaWiFi,
};

typedef NS_ENUM(NSUInteger, OffcnSDKMsgType) {
    OffcnSDKMsgTypeText = 1, //文本消息
    OffcnSDKMsgTypePicture,  //图片消息
    OffcnSDKMsgTypeAudio,    //音频消息
    OffcnSDKMsgTypeVideo,    //视频消息
    OffcnSDKMsgTypeFile,     //文件消息
};

typedef NS_ENUM(NSUInteger, OffcnSDKMsgScope) {
    OffcnSDKMsgScopeSingleChat = 1, //单聊消息
    OffcnSDKMsgScopeGroupChat,      //群聊消息
};

typedef NS_ENUM(NSUInteger, OffcnSDKType) {
    OffcnSDKTypeIM = 1, //IM 消息
};

//网络监听回调
typedef void(^OffcnSDKReachabilityStatusCallBack)(OffcnSDKReachabilityStatus status);

@interface OffcnIMSDKiOS : NSObject

//返回单例对象
+ (OffcnIMSDKiOS *)defaultService;

//是否选用测试环境
@property (nonatomic, assign) BOOL isTest;

//deviceToken
@property (nonatomic, copy) NSString *deviceToken;


@property (nonatomic, assign) OffcnSDKReachabilityStatus OffcnReachabilityStatus;
@property (nonatomic, copy) OffcnSDKReachabilityStatusCallBack reachabilityStatusCallBack;

//监听网络状态
-(void)startNotifierUseRealReachability;

@end
