//
//  GeneralDefine.h
//
//

#ifndef GeneralDefine_h
#define GeneralDefine_h

#define NSLog(format, ...) do {                                             \
fprintf(stderr, "<%s : %d> %s\n",                                           \
[[[NSString stringWithUTF8String:__FILE__] lastPathComponent] UTF8String],  \
__LINE__, __func__);                                                        \
(NSLog)((format), ##__VA_ARGS__);                                           \
fprintf(stderr, "-------\n");                                               \
} while (0)
#undef NSLog
#if       DEBUG
#define NSLog(FORMAT, ...) fprintf(stderr,"\nfunction:%s line:%d content:%s\n", __FUNCTION__, __LINE__, [[NSString stringWithFormat:FORMAT, ##__VA_ARGS__] UTF8String]);
#else
#define NSLog(FORMAT, ...)
#endif

#define KCustomerAPPKEY @"offcn_live"
#define KCustomerSecre @"offcn_im"

#pragma mark - 尺寸所有宏

#define Screen_Height [UIScreen mainScreen].bounds.size.height
#define Screen_Width [UIScreen mainScreen].bounds.size.width

#define kScreen_Height MAX(Screen_Width, Screen_Height)
#define kScreen_Width MIN(Screen_Width, Screen_Height)
//iphone6屏幕比例
#define KWidth_Scale kScreen_Width/375.0f

#define KKeyWindow [UIApplication sharedApplication].keyWindow

#define KFirstWindow [UIApplication sharedApplication].windows.firstObject

//判断是否有刘海
#define kIsIPhoneXSerious @available(iOS 11.0, *) && [UIApplication sharedApplication].windows.firstObject.safeAreaInsets.bottom > 0.0
#define kIsIphoneX kIsIPhoneXSerious
//iphoneX 竖屏安全区域顶部(如果导航栏是系统的写0就好)
#define kSafeAreaTopHeigth (kIsIphoneX?44:0)
//iphoneX 竖屏安全区域底部(如果导航栏是系统的写0就好)
#define kSafeAreaBottomHeigth (kIsIphoneX?34:0)
// 竖屏导航栏高度
#define kNavigationHeight (kIsIphoneX?88:64)
//竖屏状态栏
#define KStatusBarHeight (kIsIphoneX?44:20)

#define KFontNameBoldSize(f) [UIFont boldSystemFontOfSize:f]

#define KFontNameMediumSize(f) [UIFont systemFontOfSize:f]

#define KSetFont(size) [UIFont systemFontOfSize:size]

#define KImageNamed(name) [UIImage imageNamed:[NSString stringWithFormat:@"OffcnIMSDKiOS.bundle/%@",name]]

#define KEmojiImageNamed(name) [UIImage imageNamed:[NSString stringWithFormat:@"OffcnIMSDKiOS.bundle/emoji/%@",name]]


#define KWeakSelf __weak typeof(self) weakSelf = self;

/** 从RGB转换成UIColor （16进制->10进制）*/
#define kUIColorFromRGB(rgbValue) [UIColor \
colorWithRed:((float)((rgbValue & 0xFF0000) >> 16))/255.0 \
green:((float)((rgbValue & 0xFF00) >> 8))/255.0 \
blue:((float)(rgbValue & 0xFF))/255.0 alpha:1.0]
//****************设置颜色
#define UICOLOR_RGB_Alpha(_color,_alpha) [UIColor colorWithRed:((_color>>16)&0xff)/255.0f green:((_color>>8)&0xff)/255.0f blue:(_color&0xff)/255.0f alpha:_alpha]

#define random(r, g, b, a) [UIColor colorWithRed:(r)/255.0 green:(g)/255.0 blue:(b)/255.0 alpha:(a)/255.0]

#define randomColor random(arc4random_uniform(256), arc4random_uniform(256), arc4random_uniform(256), arc4random_uniform(256))

//小班课控制器的背景颜色
#define KOffcnSmallClassBackColor UICOLOR_RGB_Alpha(0x484d5c, 1)

//大班课控制器的背景颜色
#define KControllerBackColor UICOLOR_RGB_Alpha(0xf5f5f5, 1)
//直播状态
#define KRoomStateReasonsBackColor UICOLOR_RGB_Alpha(0x292929, 1)

//按钮普通状态
#define KButtonNormalColor UICOLOR_RGB_Alpha(0x333333, 1)
//按钮高亮状态
#define KButtonHighlightedColor UICOLOR_RGB_Alpha(0xFF5656, 1)
//按钮选中状态
#define KButtonSelectColor UICOLOR_RGB_Alpha(0xff895f, 1)
//按钮禁止状态
#define KButtonDisColor UICOLOR_RGB_Alpha(0xbfbfbf, 1)
//通知状态
#define KAlartBackColor UICOLOR_RGB_Alpha(0xffe6e0, 1)

//文字基本颜色
#define KTextColor UICOLOR_RGB_Alpha(0x333333, 1)
//标签文字基本颜色
#define KSubTagTextColor UICOLOR_RGB_Alpha(0x666666, 1)
//标签描边颜色
#define KSubTagLineColor UICOLOR_RGB_Alpha(0xcccccc, 1)
//副标题颜色
#define KSubTextColor UICOLOR_RGB_Alpha(0x999999, 1)
//人数颜色
#define KNumColor UICOLOR_RGB_Alpha(0x0d152d, 1)
//separatorColor颜色
#define KSeparatorColor UICOLOR_RGB_Alpha(0xe6e6e6, 1)
//textFiledplaceholder 文字颜色
#define KplaceholderLabelColor UICOLOR_RGB_Alpha(0xb3b3b3, 1)
//switch按钮颜色
#define KSwitchColor UICOLOR_RGB_Alpha(0x007aff, 1)

#define RGB(r, g, b) \
[UIColor colorWithRed:r/255.0 green:g/255.0 blue:b/255.0 alpha:1]

#define RGBA(r, g, b, a) \
[UIColor colorWithRed:r/255.0 green:g/255.0 blue:b/255.0 alpha:a]


////获取版本号
#define KAppVersion [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleShortVersionString"]

//#define KUUIDString [UIDevice currentDevice].identifierForVendor.UUIDString

#define KRootTabBarController KKeyWindow.rootViewController

#define KUSERDEFAULT [NSUserDefaults standardUserDefaults]
//字符串是否为空
#define KStringIsEmpty(str) ([str isKindOfClass:[NSNull class]] || str == nil || [str length] < 1 ? YES : NO )
//全字符串是否为空
#define KOffcnStringIsEmpty(str) ([str isKindOfClass:[NSNull class]] || str == nil || [str isEqual: @"null"] || [str isEqual: @"<null>"] || [str isEqual: @"nil"] || [str length] < 1 ? YES : NO )
//数组是否为空
#define KArrayIsEmpty(array) (array == nil || [array isKindOfClass:[NSNull class]] || array.count == 0)

/// View 圆角
#define ViewRadius(View, Radius)\
\
[View.layer setCornerRadius:(Radius)];\
[View.layer setMasksToBounds:YES]

///  View加边框
#define ViewBorder(View, BorderColor, BorderWidth)\
\
View.layer.borderColor = BorderColor.CGColor;\
View.layer.borderWidth = BorderWidth;

//获取系统版本
#define XZSystemVersion ([UIDevice currentDevice].systemVersion.floatValue)
#define iOS11           (XZSystemVersion >= 11.0)
#define iOS10           (XZSystemVersion >= 10.0)
#define iOS9            (XZSystemVersion >= 9.0)
#define iOS8            (XZSystemVersion >= 8.0)
#define iOS7            (XZSystemVersion >= 7.0)
#define iOS6            (XZSystemVersion <  7.0)

/**
 单例宏定义，可用可不用
 */
// .h文件
#define HHSingletonH(name) + (instancetype)shared##name;

// .m文件
#define HHSingletonM(name) \
static id _instance = nil; \
+ (id)allocWithZone:(struct _NSZone *)zone \
{ \
static dispatch_once_t onceToken; \
dispatch_once(&onceToken, ^{ \
_instance = [super allocWithZone:zone]; \
}); \
return _instance; \
} \
+ (instancetype)shared##name \
{ \
static dispatch_once_t onceToken; \
dispatch_once(&onceToken, ^{ \
_instance = [[self alloc] init]; \
}); \
return _instance; \
} \
- (id)copyWithZone:(NSZone *)zone \
{ \
return _instance; \
}



#endif /* GeneralDefine_h */
