#ifndef __OFFCN_IM__TYPES_H__
#define __OFFCN_IM__TYPES_H__

#include <stdio.h>

#ifdef _WIN32
#define ZG_OIM_API_EXPORT __declspec(dllexport)
#define ZG_OIM_API_IMPORT __declspec(dllimport)
#else
#define ZG_OIM_API_EXPORT __attribute__ ((visibility("default")))
#define ZG_OIM_API_IMPORT 
#endif

#ifdef __cplusplus
#define ZG_OIM_C_API_EXPORT extern "C" ZG_OIM_API_EXPORT
#define ZG_OIM_C_API_IMPORT extern "C" ZG_OIM_API_IMPORT
#else
#define ZG_OIM_C_API_EXPORT ZG_OIM_API_EXPORT
#define ZG_OIM_C_API_IMPORT ZG_OIM_API_IMPORT
#endif

#ifdef ZG_OIM_SDK_EXPORTS		//need define this micro,when build dll, undefine this micro when use this dll
#define ZG_OIM_C_API ZG_OIM_C_API_EXPORT
#else
#define ZG_OIM_C_API ZG_OIM_C_API_IMPORT
#endif

namespace offcn
{
namespace im
{
	typedef enum
	{
		kMsg_Type_Normal,		//normal message type
		kMsg_Type_Recv_Confirm,	//client recv message confirm type
	}OImMsgType;

	typedef enum
	{
		Z_CONN_IM_SRV_OK,
		Z_CONN_IM_SRV_FAILED,
		Z_CONN_IM_SRV_BROKEN,
		Z_DISCONN_IM_SRV_OK,

		Z_CONN_IM_SRV_RECONNECT_START,		//start reconnect
		Z_CONN_IM_SRV_RECONNECT_SUCCESS,	//reconnect success
		Z_CONN_IM_SRV_RECONNECT_FAILED,
	}OImEventCode;

	class OImCoreObserver
	{
	public:
		virtual void OnOImCoreEvent(OImEventCode nEvent, int nCode, const char *context) = 0;
		virtual void OnOImCoreMessage(const char *message, int len) = 0;
	};
}	
}

#endif
