//
//  OffcnIMSocketManager.h
//  OffcnIMSDKiOS
//
//  Created by vockey on 2020/8/24.
//  Copyright © 2020 offcn. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "OffcnIMModel.h"

NS_ASSUME_NONNULL_BEGIN

//收到消息通知
#define kRevMsgNotification @"kRevMsgNotification"
//收到消息状态通知
#define kRevMsgStateNotification @"kRevMsgStateNotification"

//收到私聊消息通知
#define kRevPrivateMsgNotification @"kRevPrivateMsgNotification"

typedef NS_ENUM(NSUInteger, OffcnIMConnectStatus) {
    OffcnIMConnectStatusMissingParameter = 201019,  //缺少参数
    OffcnIMConnectStatusInitializing = 201029,  //连接初始化中
    
    OffcnIMConnectStatusSuccess = 0,        //连接成功
    OffcnIMConnectStatusFail = 1,           //连接失败
    OffcnIMConnectStatusBreak = 2,          //连接断开
    OffcnIMConnectStatusDisConnectOK = 3,   //手动断开成功
    
    OffcnIMConnectStatusReconnect_start = 4,   //开始重连
    OffcnIMConnectStatusReconnect_success = 5, //重连成功
    OffcnIMConnectStatusReconnect_fail = 6,    //重连失败
    
    OffcnIMConnectStatusOverLimit = 3001,        //连接数量超过限制
    OffcnIMConnectStatusUserNoExist = 5002,        //用户不存在
    OffcnIMConnectStatusTokenInvalid = 5003,        //token已失效
    OffcnIMConnectStatusKickout = 8002,        //账号被踢
};

@protocol OffcnIMSocketDelegate <NSObject>

@optional
//收到消息
-(void)offcnIMSocketReceiveMessageModel:(OffcnIMModel *)IMModel;

//连接状态
-(void)offcnIMSocketConnectStatus:(OffcnIMConnectStatus)status errorMessage:(NSString *)errorMessage;
@end


//收到消息回调
typedef void(^OffcnIMConnectReceiveMessage)(OffcnIMModel *IMModel);

//连接状态回调
typedef void(^OffcnIMReceiveConnectStatus)(OffcnIMConnectStatus status,NSString *errorMessage);

@interface OffcnIMSocketManager : NSObject

@property (nonatomic, weak) id<OffcnIMSocketDelegate> delegate;

@property (nonatomic, copy) NSString *avatar;//发送消息的用户头像
@property (nonatomic, copy) NSString *msg_fromId;//发送消息的用户id
@property (nonatomic, copy) NSString *token;//发送消息的用户token

@property (nonatomic, strong) OffcnIMSettingsModel *IMSettingsModel;//IM基础配置

@property (nonatomic, assign) OffcnIMConnectStatus IMConnectStatus;//连接状态

//收到消息回调
@property (nonatomic, copy) OffcnIMConnectReceiveMessage connectReceiveMessage;

//连接状态回调
@property (nonatomic, copy) OffcnIMReceiveConnectStatus connectStatus;

@property (nonatomic, strong) NSMutableArray *msgArr;//收到消息防止重复msg_id缓存池
@property (nonatomic, strong) NSMutableArray *msgTidArr;//发送消息防止重复tid缓存池
//单例
+(OffcnIMSocketManager *)defaultService;

/// 进入一个会话需要传入当前会话的参数
/// @param session_fromId 当前会话发送消息的用户id
/// @param session_toId 当前会话接收消息的用户id
-(void)joinSessionWithSession_fromId:(NSString *)session_fromId session_toId:(NSString *)session_toId callBack:(void(^)(NSInteger unread_number,NSString *fromUser,NSString *toUser))numberBack;

/// 建立连接
/// @param account_id 用户ID
/// @param token 用户token
-(void)connectIMServerWithAccount_id:(NSString *)account_id token:(NSString *)token;

//主动断开连接，不会重连
-(void)disConnectIMServerForever;

//重新连接
-(void)reconnectionIMServerForever;

//后台收到消息本地推送
-(void)manualSendLocalNotificationWithModel:(OffcnIMModel *)model;
@end

NS_ASSUME_NONNULL_END
