//
//  OffcnIMModel.h
//  OffcnIMSDKiOS
//
//  Created by vockey on 2020/8/25.
//  Copyright © 2020 offcn. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class OffcnIMBodyModel;
@interface OffcnIMModel : NSObject

@property (nonatomic,assign)NSInteger type;//报文类型,1:IM 消息
@property (nonatomic,strong)OffcnIMBodyModel *body;
@end

@class OffcnIMMsgModel,OffcnIMPrivateChatListModel;
@interface OffcnIMBodyModel : NSObject

@property (nonatomic,assign)BOOL isPassTime; //超时5分钟
@property (nonatomic,assign)BOOL isPlayAudio; //播放语音中

@property (nonatomic,assign)BOOL is_top;//是否置顶
@property (nonatomic,copy)NSString *session_id; //会话ID
@property (nonatomic,copy)NSString *msg_id;//消息Id
@property (nonatomic,copy)NSString *version;
@property (nonatomic,copy)NSString *send_time;//发送时间
@property (nonatomic,assign)NSInteger msg_seq;//消息时序
@property (nonatomic,assign)NSInteger msg_scope;//单聊：1;群聊：2;私聊: 9;客服: 10
@property (nonatomic,assign)NSInteger cell_type;//1:群发消息，2:单发消息
@property (nonatomic,copy)NSString *msg_from;//发送消息的用户id
@property (nonatomic,copy)NSString *msg_to;//接受消息的用户id
@property (nonatomic,copy)NSString *to;//对方Id
@property (nonatomic,assign)NSInteger msg_type;//消息类型
@property (nonatomic,strong)OffcnIMMsgModel *msg;//消息内容

@property (nonatomic,assign)BOOL isJoinSession;//

@property (nonatomic,copy)NSString *ext;//im开发者扩展字段,私聊内容
@property (nonatomic,strong)OffcnIMPrivateChatListModel *privateModel;//私聊内容

@property (nonatomic,copy)NSString *extIndex;//开发者扩展字段
@property (nonatomic,assign)CGFloat cellH;//扩展字段
@property (nonatomic,copy)NSString *ext_custom;//开发者扩展字段
@property (nonatomic,assign)NSInteger numberTip;//扩展字段
@property (nonatomic,assign)NSInteger index;


//客服使用
@property (nonatomic,copy)NSString *group_id;//客服组ID
@property (nonatomic,assign)BOOL is_agent;//是否教师身份登陆
@property (nonatomic,copy)NSString *ref_msgid;//已评价消息ID


//以下数据库使用
@property (nonatomic,assign)NSInteger isSentSuccess;//是否发送成功
@property (nonatomic,assign)NSInteger bymyself;//是否是我发送的
@property (nonatomic,assign)NSInteger isRead;//是否已读
@property (nonatomic,copy)NSString *lastmessage;//最后一条消息
@property (nonatomic,copy)NSString *lastSendtime;//最后一条消息时间
@property (nonatomic,copy)NSString *tid;//本地的消息Id
@property (nonatomic,assign)BOOL isGroupSendMsg;//是否群发消息
@property (nonatomic,assign)NSInteger unread_number;//每个会话的未读数
@property (nonatomic,assign)NSInteger total_unread_number;//所有会话总未读数
@end


@class OffcnIMCSEvaluation_typeModel;
@interface OffcnIMMsgModel : NSObject

@property (nonatomic,copy)NSString *msg;//文本消息内容

@property (nonatomic,assign)NSInteger dur;//只有音频消息和视频消息返回的时长ms
@property (nonatomic,copy)NSString *name;//只有图片消息和文件消息返回的名字
@property (nonatomic,copy)NSString *md5;//md5
@property (nonatomic,copy)NSString *url;//下载地址
@property (nonatomic,copy)NSString *thumb_url;//只有图片消息返回的缩略图URL
@property (nonatomic,copy)NSString *cover_url;//只有视频消息返回的视频封面url
@property (nonatomic,copy)NSString *ext;//文件类型
@property (nonatomic,assign)NSInteger w;//宽
@property (nonatomic,assign)NSInteger h;//高
@property (nonatomic,assign)NSInteger size;//文件大小


//客服使用
@property (nonatomic,copy)NSString *group_id;//客服组ID
@property (nonatomic,assign)NSInteger type;//评价类型：1满意；2解决
@property (nonatomic,strong)OffcnIMCSEvaluation_typeModel *reply;//评价按钮状态
@end

//发送消息Model
@interface OffcnIMSendMsgModel : NSObject

@property (nonatomic,copy)NSString *msg_id;//消息Id
@property (nonatomic,copy)NSString *send_time;//发送时间
@property (nonatomic,copy)NSString *session_id; //会话ID
@property (nonatomic,copy)NSString *tid;//本地的消息Id
@end

//获取会话未读消息列表Model
@interface OffcnIMUnreadMsgModel : NSObject

@property (nonatomic,copy)NSString *version;
@property (nonatomic,copy)NSString *lrms;//用户关于当前会话最后已读的消息序列号
@property (nonatomic,strong)NSMutableArray *msg_list;
@end


//获取用户最近会话记录Model
@interface OffcnIMRecentMsgModel : NSObject

@property (nonatomic,strong)NSMutableArray *sessions;
@end

@class OffcnIMLast_msgModel;
@interface OffcnIMSessionModel : NSObject

@property (nonatomic,assign)BOOL is_top;//是否置顶
@property (nonatomic,strong)OffcnIMLast_msgModel *last_msg;//消息信息
@property (nonatomic,copy)NSString *session_id;//会话Id
@property (nonatomic,copy)NSString *to;//对方Id
@property (nonatomic,assign)NSInteger type;//类型
@property (nonatomic,assign)NSInteger unread_number;//数量

//客服使用
@property (nonatomic,copy)NSString *group_id;//客服组ID
@end

@interface OffcnIMLast_msgModel : NSObject

@property (nonatomic,copy)NSString *ext;//开发者扩展字段
@property (nonatomic,strong)OffcnIMMsgModel *msg;//消息内容
@property (nonatomic,assign)NSInteger msg_type;//消息类型
@property (nonatomic,copy)NSString *send_time;//时间
@property (nonatomic,copy)NSString *session_id; //会话ID
@property (nonatomic,copy)NSString *msg_id;//消息Id
@property (nonatomic,copy)NSString *version;
@property (nonatomic,assign)NSInteger msg_seq;//消息时序
@property (nonatomic,assign)NSInteger msg_scope;// 区分单聊：1以及群聊：2
@property (nonatomic,copy)NSString *msg_from;//发送消息的用户id
@property (nonatomic,copy)NSString *msg_to;//接受消息的用户id
@property (nonatomic,copy)NSString *to;//对方Id
@property (nonatomic,copy)NSString *tid;//本地发送消息tid

//客服使用
@property (nonatomic,copy)NSString *group_id;//客服组ID
@end

//获取会话历史消息列表Model
@interface OffcnIMHistoryMsgModel : NSObject

@property (nonatomic,copy)NSString *version;
@property (nonatomic,strong)NSMutableArray *msg_list;
@end


//推送Model
@class OffcnIMPushApsModel;
@interface OffcnIMPushModel : NSObject

@property (nonatomic,strong)OffcnIMModel *message;
@property (nonatomic,strong)OffcnIMPushApsModel *aps;
@end

@interface OffcnIMPushApsModel : NSObject

@property (nonatomic,strong)NSDictionary *alert;
@property (nonatomic,copy)NSString *badge;
@property (nonatomic,copy)NSString *sound;
@end


//IM基础配置
@interface OffcnIMSettingsGatewayModel : NSObject

@property (nonatomic,copy)NSString *server_ip;
@property (nonatomic,assign)NSInteger server_port_kcp;
@property (nonatomic,assign)NSInteger server_port_ws;
@property (nonatomic,assign)NSInteger server_port_wss;
@end

@interface OffcnIMSettingsModel : NSObject

@property (nonatomic,strong)OffcnIMSettingsGatewayModel *gateway;
@end


@class OffcnIMUserList_list_classesModel;
@interface OffcnIMUserList_listModel : NSObject

//单独使用聊天详情页面时（必传）
@property (nonatomic, assign) NSInteger cell_type;//1:群发消息，2:单发消息

//群发使用;选用
@property (nonatomic, copy) NSString *key;//群ID
@property (nonatomic, strong) OffcnIMUserList_list_classesModel *classes;//群成员


//详情页展示需要传入

//房间信息
@property (nonatomic, copy) NSString *room_name;//房间标题
@property (nonatomic, copy) NSString *room_time;//直播时间例如：@"12:00-15:00"
@property (nonatomic, copy) NSString *room_class;//所属班级
@property (nonatomic, copy) NSString *room_num;//房间号

//对方信息
@property (nonatomic, copy) NSString *avatar;//头像地址
@property (nonatomic, copy) NSString *sortChar;//无地址时头像展示一个字（暂无此功能）
@property (nonatomic, copy) NSString *avatar_color;//无地址时头像背景色（暂无此功能）
@property (nonatomic, copy) NSString *name;//名字
@property (nonatomic, copy) NSString *remark;//备注名
@property (nonatomic, copy) NSString *phone;//用户手机号
@property (nonatomic, copy) NSString *name_original;//原始名字
@property (nonatomic, copy) NSString *user_id;//对方ID;如果是群发消息，user_id以@","拼接（必传）

//教师信息
@property (nonatomic, copy) NSString *group_id;//客服组id（必传）
@property (nonatomic, copy) NSString *identity;//身份
@property (nonatomic, copy) NSString *ability;//能力，例如：老师答疑题型范围等
@property (nonatomic, copy) NSString *teacherName;//名字
@property (nonatomic, copy) NSString *teacherAvatar;//头像地址
@property (nonatomic, copy) NSString *teacherPhone;//手机号


@property (nonatomic, copy) NSString *expand;//拓展字段
@property (nonatomic, assign) NSInteger expandH;//拓展字段
@end

@interface OffcnIMUserList_list_classesModel : NSObject

@property (nonatomic, copy) NSString *count;//成员人数
@property (nonatomic, strong) NSMutableArray *name;//成员名字
@end


//私聊
@interface OffcnIMPrivateChatListModel : NSObject

@property (nonatomic,assign)BOOL is_top;//是否置顶
@property (nonatomic,assign)CGFloat cellH;//扩展字段

@property (nonatomic,copy)NSString *ID;

@property (nonatomic,copy)NSString *create_time;

@property (nonatomic,copy)NSString *msg_to;
@property (nonatomic,copy)NSString *msg_to_name;
@property (nonatomic,copy)NSString *msg_to_role;

@property (nonatomic,copy)NSString *msg_from;
@property (nonatomic,copy)NSString *msg_from_name;
@property (nonatomic,copy)NSString *msg_from_role;

@property (nonatomic,assign)NSInteger num;// 未读消息数
@property (nonatomic,assign)NSInteger online;// 是否在线 0:不在线 1:在线
@property (nonatomic,copy)NSString *room_num;
@property (nonatomic,copy)NSString *send_time;
@property (nonatomic,copy)NSString *msg_unique;

@property (nonatomic,strong)NSMutableArray *content;//消息内容

@property (nonatomic,copy)NSMutableAttributedString *attributedS;//文本消息内容

@property (nonatomic,assign)BOOL isPrivating;//在私聊界面
@property (nonatomic,assign)BOOL isHasPrivated;//以前私聊过
@end

@interface OffcnIMPrivateChatContentModel : NSObject

@property (nonatomic,copy)NSString *type;//text/face/image
@property (nonatomic,copy)NSString *data;

@property (nonatomic,copy)NSString *msg;//消息ID

@property (nonatomic,copy)NSString *uuid;//被@人的id
@property (nonatomic,copy)NSString *nickname;//被@人的name

@property (nonatomic,assign)BOOL isDeletBtn;

@end


//客服
@interface OffcnIMCSAutoreplyModel : NSObject

@property (nonatomic,copy)NSString *auto_reply_default;
@property (nonatomic,strong)NSMutableArray *list;

@property (nonatomic,assign)NSInteger online_status;//1:正常;2:忙碌

@property (nonatomic,assign)BOOL isSure;
@end

@interface OffcnIMCSAutoreply_listModel : NSObject

@property (nonatomic,copy)NSString *accid;
@property (nonatomic,copy)NSString *content;
@property (nonatomic,copy)NSString *ID;
@property (nonatomic,assign)NSInteger is_default;

@property (nonatomic,assign)NSInteger type;//1-无；2-添加自动回复
@property (nonatomic,copy)NSString *auto_reply_id;
@end


@interface OffcnIMCSEvaluationModel : NSObject

@property (nonatomic,assign)NSInteger type;//1-满意；2-解决
@end


//评价按钮状态
@interface OffcnIMCSEvaluation_typeModel : NSObject

@property (nonatomic,copy)NSString *accid;
@property (nonatomic,copy)NSString *create_at;
@property (nonatomic,assign)NSInteger value;//1-满意；2-不满意
@end


//申请人工客服
@interface OffcnIMCSAgent_applyModel : NSObject

@property (nonatomic,copy)NSString *agent_id;//客服组ID
@end

//聊天回复是否存在
@interface OffcnIMCSReplyModel : NSObject

@property (nonatomic,assign)NSInteger reply_count;//>0为回复
@end


NS_ASSUME_NONNULL_END
