//
//  OffcnIMChatListViewController.h
//  classonline
//
//  Created by HX on 2020/10/14.
//  Copyright © 2020 offcn. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "OffcnIMModel.h"

NS_ASSUME_NONNULL_BEGIN

//消息总数回调
typedef void(^OffcnIMTotal_unread_number)(NSInteger num);

//点击cell事件
typedef void(^OffcnIMDidSelectRowCallBack)(OffcnIMUserList_listModel *contactInfoModel);


@interface OffcnIMChatListViewController : UIViewController

@property (nonatomic, assign) BOOL isNavBarHidden;//是否隐藏导航

/// 自定义UI
/// @param viewTopHeight （view top的高度,一级子视图传0，二级子视图传0.1或自定义高度）
/// @param viewBottomHeight （view bottom的高度）
/// @param isNeedSearch 是否需要搜索功能
-(void)setUIWithViewTopHeight:(CGFloat)viewTopHeight ViewBottomHeight:(CGFloat)viewBottomHeight isNeedSearch:(BOOL)isNeedSearch;

@property (nonatomic, assign) BOOL isShowNoWifiTip;//显示没网提示

@property (nonatomic, copy) OffcnIMTotal_unread_number total_unread_number;//消息总数回调

@property (nonatomic, copy) OffcnIMDidSelectRowCallBack didSelectRowCallBack;//点击cell事件


//返回联系人信息--userID为im的用户ID
-(OffcnIMUserList_listModel *)getContactInfoModelWithUserID:(NSString *)userID;


//清空数据
-(void)clearData;

//刷新
-(void)reloadData;

@end

NS_ASSUME_NONNULL_END
