//
//  OffcnIMCSChatInfoViewController.h
//  classonline
//
//  Created by HX on 2020/10/14.
//  Copyright © 2020 offcn. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "OffcnIMModel.h"

NS_ASSUME_NONNULL_BEGIN

//自己发送消息通知
#define kCSSendMsgNotification @"kCSSendMsgNotification"
#define kResultKey @"kResultKey"
#define kObjcKey @"kObjcKey"
#define kGroup_idKey @"kGroup_idKey"

//页面显示消失
#define kCSPageShowNotification @"kCSPageShowNotification"

@class OffcnIMContactInfoModel;

@interface OffcnIMCSChatInfoViewController : UIViewController


//联系人model
@property (nonatomic, strong) OffcnIMUserList_listModel *contactInfoModel;


/// 返回联系人信息
/// @param agent_ID 客服ID
/// @param toID 对方ID
/// @param group_id 客服组ID
-(OffcnIMUserList_listModel *)cs_getContactInfoModelWithAgent_ID:(NSString *)agent_ID toID:(NSString *)toID group_id:(NSString *)group_id;



//聊天内容点击链接是否跳转浏览器(yes:跳转浏览器；no:不跳转，返回的链接根据产品需求处理)
-(BOOL)isJumpToBrowserWithLinkUrlStr:(NSString *)linkUrlStr;


/// 满足条件：“学员在班级&班级状态不是已结班”  或  “学员在学习包内”返回NO，否则返回YES
/// @param teacherID 教师ID
/// @param studentID 学生ID
/// @param group_id 客服组ID
-(BOOL)isEndClassWithTeacherID:(NSString *)teacherID studentID:(NSString *)studentID group_id:(NSString *)group_id;


//滑动到底部
- (void)scrollTableToFoot:(BOOL)animated;

//刷新
-(void)reloadData;
@end

NS_ASSUME_NONNULL_END
