//
//  OffcnIMSqliteTestVC.m
//  OffcnIMSDKiOS
//
//  Created by vockey on 2020/9/1.
//  Copyright © 2020 offcn. All rights reserved.
//

#import "OffcnIMSqliteTestVC.h"
#import "OffcnIMZYJ1FMDBHandler.h"
#import "OffcnIMModel.h"

#import "OffcnZYJ1TestDataStorageView.h"

@interface OffcnIMSqliteTestVC ()

@property (assign, nonatomic) UIClearStyle clearStyle;
@end

@implementation OffcnIMSqliteTestVC

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.title = @"数据库";
    
    self.clearStyle = UIClearStyleAll;
}

//删除记录
- (IBAction)deleteRecord:(UIButton *)sender {
   
    [[OffcnIMZYJ1FMDBHandler sharedInstance] deleteUserChatDataWithFromUser:self.fromId toUser:self.toId clearStyle:self.clearStyle callBack:^(BOOL isSuccess) {
        
    }];
}

//删除表格
- (IBAction)deleteTable:(UIButton *)sender {
    
    [[OffcnIMZYJ1FMDBHandler sharedInstance] deleteDataTable];
}

//查询聊天列表
- (IBAction)queryChatList:(UIButton *)sender {
    
    [[OffcnIMZYJ1FMDBHandler sharedInstance] getChatListArrayWithFromUser:self.fromId Callback:^(NSArray<OffcnIMBodyModel *> *messagesArray) {
        
        NSString *msg = @"";
        for (int i=0; i<messagesArray.count; i++) {
            OffcnIMBodyModel *model = messagesArray[i];
            msg = [msg stringByAppendingString:[NSString stringWithFormat:@"发送人ID:%@,接收人ID:%@,消息类型:%ld,时间:%@,内容:%@,未读数:%ld,拓展内容:%@",model.msg_from,model.msg_to,(long)model.msg_type,model.lastSendtime,model.lastmessage,(long)model.unread_number,model.ext]];
            
            msg = [msg stringByAppendingString:@"\r\n"];
            msg = [msg stringByAppendingString:@"\r\n"];
        }
        
        OffcnZYJ1TestDataStorageView *storageView = [[OffcnZYJ1TestDataStorageView alloc] initWithFrame:CGRectMake(0, 20, self.view.bounds.size.width, self.view.bounds.size.height-20)];
        storageView.msg = msg;
        [storageView showView];
    }];
}

//查询聊天记录
- (IBAction)queryChat:(UIButton *)sender {
    
    [[OffcnIMZYJ1FMDBHandler sharedInstance] getChatRecordArrayWithFromUser:self.fromId toUser:self.toId limit:@"20" startIndex:@"0" callback:^(NSArray<OffcnIMBodyModel *> *messagesArray) {
        
        NSString *content = @"";
        for (int i=0; i<messagesArray.count; i++) {
            OffcnIMBodyModel *model = messagesArray[i];
            NSString *sender = [NSString stringWithFormat:@"发送人ID:%@",model.msg_from];
            NSString *rever = [NSString stringWithFormat:@"接收人ID:%@",model.msg_to];
            NSString *time = [NSString stringWithFormat:@"时间:%@",model.send_time];
            NSString *msg = @"";
            if (model.msg_type == 1) {
                //文本消息
                msg = [msg stringByAppendingString:model.msg.msg?model.msg.msg:@"nil"];
            }else{
                //非文本消息
                msg = [msg stringByAppendingString:model.msg.url?model.msg.url:@"nil"];
            }
            
            NSString *allmsg = [NSString stringWithFormat:@"%@,%@,%@,消息:%@,拓展内容:%@",sender,rever,time,msg,model.ext];
            
            content = [content stringByAppendingString:allmsg];
            
            content = [content stringByAppendingString:@"\r\n"];
            content = [content stringByAppendingString:@"\r\n"];
        }
        
        OffcnZYJ1TestDataStorageView *storageView = [[OffcnZYJ1TestDataStorageView alloc] initWithFrame:CGRectMake(0, 20, self.view.bounds.size.width, self.view.bounds.size.height-20)];
        storageView.msg = content;
        [storageView showView];
    }];
}

//更新聊天列表未读数
- (IBAction)setUnreadNum:(UIButton *)sender {
    
    __block OffcnIMBodyModel *IMBodyModel = nil;
    [[OffcnIMZYJ1FMDBHandler sharedInstance] getChatListOneMessageWithFromUser:self.fromId toUser:self.toId callback:^(OffcnIMBodyModel *model) {
        
        IMBodyModel = model;
    }];
    
    OffcnIMBodyModel *BodyModel = [[OffcnIMBodyModel alloc] init];
    BodyModel.msg_from = self.fromId;
    BodyModel.msg_to = self.toId;
    BodyModel.unread_number = IMBodyModel.unread_number+1;
    
    [[OffcnIMZYJ1FMDBHandler sharedInstance] updateChatListUnread_number:BodyModel callBack:^(OffcnIMBodyModel *model) {
        
        NSLog(@"测试未读数%ld",(long)model.unread_number);
    }];
}

@end
