//
//  AppDelegate.m
//  OffcnIMSDKiOS
//
//  Created by vockey on 2018/7/25.
//  Copyright © 2018年 中公教育. All rights reserved.
//

#import "AppDelegate.h"
#import "ViewController.h"

#import "OffcnIMSDKiOS.h"
#import "OffcnIMSocketManager.h"
#import "OffcnIMZYJ1FMDBHandler.h"
#import "OffcnIMPushManager.h"

@interface AppDelegate ()

@end

@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    
    self.window = [[UIWindow alloc]initWithFrame:[UIScreen mainScreen].bounds];
    UINavigationController *mainVC = [[UINavigationController alloc] initWithRootViewController:[[UIStoryboard storyboardWithName:@"Main" bundle:nil] instantiateInitialViewController]];
    
    mainVC.navigationBar.translucent = NO;
    self.window.rootViewController = mainVC;
    self.window.backgroundColor = [UIColor whiteColor];
    [self.window makeKeyAndVisible];
    
    
    //中公直播使用测试环境设置为YES，正式环境设置为NO或者去掉这个配置
//    NSNumber *changeEnvironment = [[NSUserDefaults standardUserDefaults] valueForKey:kOffcnIMSDKiOS_changeEnvironment];
//    NSLog(@"changeEnvironment---%@",changeEnvironment);
//    [OffcnIMSDKiOS defaultService].isTest = [changeEnvironment boolValue];
    
    
    //启动SDK
    [[OffcnIMSDKiOS defaultService] setupWithIsTest:YES];
    //注册系统推送
    [OffcnIMPushManager registerOffcnUserNotification];
    
    //获取用户相关数据库，该方法在登陆或者第一次启动已登陆下执行
    [[OffcnIMZYJ1FMDBHandler sharedInstance] getUserDB];
    
    
    return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application {

}

- (void)applicationDidEnterBackground:(UIApplication *)application {
    
}


- (void)applicationWillEnterForeground:(UIApplication *)application {

}

- (void)applicationWillTerminate:(UIApplication *)application {
    
}

- (void)applicationDidBecomeActive:(UIApplication *)application {
    
    //进入前台,清除推送角标
    [UIApplication sharedApplication].applicationIconBadgeNumber = 1;
    [UIApplication sharedApplication].applicationIconBadgeNumber = 0;
    [application cancelAllLocalNotifications];
//    [JPUSHService setBadge:0];
}

//远程推送注册成功
- (void)application:(UIApplication *)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken{
    // 25bb75ac 3ffcebd7 90d9f517 1ebca904 154a367a 87781e5d b9ea288e 37fdf487
    NSLog(@"-----deviceToken ---- ---- %@ devDesc ---%@", deviceToken,deviceToken.description);
    
    
    //解析deviceToken
    NSString *str = [OffcnIMPushManager hexStringForData:deviceToken];
    [OffcnIMSDKiOS defaultService].deviceToken = str;
    NSLog(@"token--- %@",str);
    
    if (self.deviceTokenCallback) {
        self.deviceTokenCallback();
    }
}

//注册失败
- (void)application:(UIApplication *)application didFailToRegisterForRemoteNotificationsWithError:(NSError *)error{
    
    NSLog(@"注册失败 ---- %@",error);
}

- (void)application:(UIApplication *)application didReceiveRemoteNotification:(NSDictionary *)userInfo fetchCompletionHandler:(void (^)(UIBackgroundFetchResult))completionHandler {
    
    NSLog(@"接收到远程推送通知Background ---- %@", userInfo);
//    [OffcnIMPushManager didReceiveRemoteNotification:userInfo Finished:^(OffcnIMPushModel * _Nonnull IMPushModel) {
//
//        NSString *sender = [NSString stringWithFormat:@"发送人ID:%@",IMPushModel.message.body.msg_from];
//        NSString *rever = [NSString stringWithFormat:@"接收人ID:%@",IMPushModel.message.body.msg_to];
//        NSString *time = [NSString stringWithFormat:@"时间:%@",IMPushModel.message.body.send_time];
//        NSString *msg = @"";
//        if (IMPushModel.message.body.msg_type == 1) {
//            //文本消息
//            msg = [msg stringByAppendingString:IMPushModel.message.body.msg.msg?IMPushModel.message.body.msg.msg:@"nil"];
//        }else{
//            //非文本消息
//            msg = [msg stringByAppendingString:IMPushModel.message.body.msg.url?IMPushModel.message.body.msg.url:@"nil"];
//        }
//
//        NSString *allmsg = [NSString stringWithFormat:@"%@,%@,%@,消息:%@,拓展内容:%@",sender,rever,time,msg,IMPushModel.message.body.ext];
//        dispatch_async(dispatch_get_main_queue(), ^{
//            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"远程推送通知" message:allmsg delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确定", nil];
//            [alert show];
//        });
//    }];
    
//    if ([UIApplication sharedApplication].applicationState != UIApplicationStateActive) {
//
//    }
    
    completionHandler(UIBackgroundFetchResultNewData);
}

- (void)application:(UIApplication *)application didReceiveRemoteNotification:(NSDictionary *)userInfo{
    
    NSLog(@"接收到远程推送通知 ---- %@", userInfo);
//    [OffcnIMPushManager didReceiveRemoteNotification:userInfo Finished:^(OffcnIMPushModel * _Nonnull IMPushModel) {
//
//        NSString *sender = [NSString stringWithFormat:@"发送人ID:%@",IMPushModel.message.body.msg_from];
//        NSString *rever = [NSString stringWithFormat:@"接收人ID:%@",IMPushModel.message.body.msg_to];
//        NSString *time = [NSString stringWithFormat:@"时间:%@",IMPushModel.message.body.send_time];
//        NSString *msg = @"";
//        if (IMPushModel.message.body.msg_type == 1) {
//            //文本消息
//            msg = [msg stringByAppendingString:IMPushModel.message.body.msg.msg?IMPushModel.message.body.msg.msg:@"nil"];
//        }else{
//            //非文本消息
//            msg = [msg stringByAppendingString:IMPushModel.message.body.msg.url?IMPushModel.message.body.msg.url:@"nil"];
//        }
//
//        NSString *allmsg = [NSString stringWithFormat:@"%@,%@,%@,消息:%@,拓展内容:%@",sender,rever,time,msg,IMPushModel.message.body.ext];
//        dispatch_async(dispatch_get_main_queue(), ^{
//            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"远程推送通知" message:allmsg delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确定", nil];
//            [alert show];
//        });
//    }];
}
- (void)application:(UIApplication *)application didReceiveLocalNotification:(UILocalNotification *)notification{
    NSLog(@"接收到本地推送通知 ---- %@", notification.userInfo);
//    [OffcnIMPushManager didReceiveLocalNotification:notification.userInfo Finished:^(OffcnIMModel * _Nonnull IMLocalPushModel) {
//
//        NSString *sender = [NSString stringWithFormat:@"发送人ID:%@",IMLocalPushModel.body.msg_from];
//        NSString *rever = [NSString stringWithFormat:@"接收人ID:%@",IMLocalPushModel.body.msg_to];
//        NSString *time = [NSString stringWithFormat:@"时间:%@",IMLocalPushModel.body.send_time];
//        NSString *msg = @"";
//        if (IMLocalPushModel.body.msg_type == 1) {
//            //文本消息
//            msg = [msg stringByAppendingString:IMLocalPushModel.body.msg.msg?IMLocalPushModel.body.msg.msg:@"nil"];
//        }else{
//            //非文本消息
//            msg = [msg stringByAppendingString:IMLocalPushModel.body.msg.url?IMLocalPushModel.body.msg.url:@"nil"];
//        }
//
//        NSString *allmsg = [NSString stringWithFormat:@"%@,%@,%@,消息:%@,拓展内容:%@",sender,rever,time,msg,IMLocalPushModel.body.ext];
//        dispatch_async(dispatch_get_main_queue(), ^{
//            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"本地推送通知" message:allmsg delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确定", nil];
//            [alert show];
//        });
//    }];
}

- (void)application:(UIApplication *)application didRegisterUserNotificationSettings:(UIUserNotificationSettings *)notificationSettings{
    
    NSLog(@"ls---- %@",notificationSettings);
    
    // 2.注册远程通知
    [application registerForRemoteNotifications];
}

- (void)application:(UIApplication *)application handleActionWithIdentifier:(nullable NSString *)identifier forRemoteNotification:(NSDictionary *)userInfo withResponseInfo:(NSDictionary *)responseInfo completionHandler:(void(^)(void))completionHandler{
    
    NSLog(@"ios9新增 --- %@ -- %@ --- %@",identifier,userInfo,responseInfo);
}

- (void)application:(UIApplication *)application handleActionWithIdentifier:(nullable NSString *)identifier forRemoteNotification:(NSDictionary *)userInfo completionHandler:(void(^)(void))completionHandler{
    
    NSLog(@"ios8新增 --- %@ -- %@ --- %@",identifier,userInfo,application);
}

@end
