//
//  OffcnZYJ1TestDataStorageView.m
//  OffcnLiveSDK
//
//  Created by ZYJ1 on 2020/3/28.
//  Copyright © 2020 中公教育. All rights reserved.
//

#import "OffcnZYJ1TestDataStorageView.h"

@interface OffcnZYJ1TestDataStorageView ()

@property (nonatomic, strong) UIButton *pasteBtn;
@property (nonatomic, strong) UIButton *cancellBtn;
@property (nonatomic, strong) UITextView *textView;
@end

@implementation OffcnZYJ1TestDataStorageView

-(UIButton *)pasteBtn{
    if (!_pasteBtn) {
        _pasteBtn = [[UIButton alloc] init];
        _pasteBtn.titleLabel.font = [UIFont systemFontOfSize:18];
        [_pasteBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [_pasteBtn setTitle:@"复制" forState:UIControlStateNormal];
        [_pasteBtn addTarget:self action:@selector(pasteBtnAction:) forControlEvents:UIControlEventTouchUpInside];
        _pasteBtn.backgroundColor = [UIColor redColor];
    }
    return _pasteBtn;
}
-(void)pasteBtnAction:(UIButton *)button{
    __weak typeof(self) weakSelf = self;
    dispatch_async(dispatch_get_main_queue(), ^{
        
        UIPasteboard *pasteboard = [UIPasteboard generalPasteboard];
        pasteboard.string = weakSelf.textView.text;
        NSLog(@"复制成功");
    });
}
-(UIButton *)cancellBtn{
    if (!_cancellBtn) {
        _cancellBtn = [[UIButton alloc] init];
        _cancellBtn.titleLabel.font = [UIFont systemFontOfSize:18];
        [_cancellBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        [_cancellBtn setTitle:@"关闭" forState:UIControlStateNormal];
        [_cancellBtn addTarget:self action:@selector(closeBtnAction:) forControlEvents:UIControlEventTouchUpInside];
        _cancellBtn.backgroundColor = [UIColor redColor];
    }
    return _cancellBtn;
}
-(void)closeBtnAction:(UIButton *)button{
    [self hidView];
}
-(UITextView *)textView{
    if (!_textView){
        _textView = [[UITextView alloc] initWithFrame:CGRectZero];
        _textView.font = [UIFont systemFontOfSize:13];
        _textView.textColor = [UIColor blackColor];
        _textView.textAlignment = NSTextAlignmentLeft;
        
        _textView.linkTextAttributes = @{NSForegroundColorAttributeName:[UIColor blueColor]};
        _textView.backgroundColor = [UIColor clearColor];
        _textView.textContainer.lineFragmentPadding = 0;
        _textView.textContainerInset = UIEdgeInsetsZero;
        _textView.editable = NO;
        _textView.scrollEnabled = YES;
        _textView.dataDetectorTypes = UIDataDetectorTypeLink;
    }
    return _textView;
}

-(instancetype)initWithFrame:(CGRect)frame{
    if (self = [super initWithFrame:frame]) {
        self.backgroundColor = [UIColor whiteColor];
        
        [self addSubview:self.pasteBtn];
        [self addSubview:self.cancellBtn];
        [self addSubview:self.textView];
    }
    return self;
}
-(void)layoutSubviews{
    [super layoutSubviews];
    
    self.textView.frame = CGRectMake(20, 0, self.frame.size.width-40, self.frame.size.height-30-20);
    
    self.pasteBtn.frame = CGRectMake(20, CGRectGetMaxY(self.textView.frame)+10, (self.frame.size.width-60)/2, 30);
    self.cancellBtn.frame = CGRectMake(CGRectGetMaxX(self.pasteBtn.frame)+20, self.pasteBtn.frame.origin.y, self.pasteBtn.frame.size.width, self.pasteBtn.frame.size.height);
}
-(void)showView{
    UIWindow *mainWindow = [UIApplication sharedApplication].keyWindow;
    [mainWindow addSubview:self];
    [mainWindow bringSubviewToFront:self];
    [self setNeedsLayout];
    [self layoutIfNeeded];
}
-(void)setMsg:(NSString *)msg{
    _msg = msg;
    
    self.textView.text = msg;
}
-(void)hidView{
    [self endEditing:YES];
    
    [self removeFromSuperview];
}
@end
