//
//  OffcnIMSDKiOS.h
//  OffcnIMSDKiOS
//
//  Created by vockey on 2018/10/16.
//  Copyright © 2018年 中公教育. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "OffcnIMModel.h"

static const NSString *OffcnIMSDKiOSVersion = @"1.2.3.5.1";

//聊天详情头像点击事件通知
#define kOffcnIMChatInfoHeadIconClickNotification @"kOffcnIMChatInfoHeadIconClickNotification"

typedef NS_ENUM(NSUInteger, OffcnIMChatInfoType) {
    OffcnIMChatInfoType_imChat = 1,    //im聊天
    OffcnIMChatInfoType_privateChat,   //私聊
    OffcnIMChatInfoType_csChat,        //客服
};

typedef NS_ENUM(NSUInteger, OffcnIMSDKReachabilityStatus) {
    OffcnIMSDKReachabilityStatusNotReachable = 0,
    OffcnIMSDKReachabilityStatusViaWWAN,
    OffcnIMSDKReachabilityStatusViaWiFi,
};

typedef NS_ENUM(NSUInteger, OffcnSDKMsgType) {
    OffcnSDKMsgTypeText = 1, //文本消息
    OffcnSDKMsgTypePicture,  //图片消息
    OffcnSDKMsgTypeAudio,    //音频消息
    OffcnSDKMsgTypeVideo,    //视频消息
    OffcnSDKMsgTypeFile,     //文件消息
};

typedef NS_ENUM(NSUInteger, OffcnSDKMsgScope) {
    OffcnSDKMsgScopeSingleChat = 1, //单聊消息
    OffcnSDKMsgScopeGroupChat,      //群聊消息
};

typedef NS_ENUM(NSUInteger, OffcnSDKType) {
    OffcnSDKTypeIM = 1, //IM 消息
};

//网络监听回调
typedef void(^OffcnIMSDKReachabilityStatusCallBack)(OffcnIMSDKReachabilityStatus status);

//聊天详情头像点击事件回调
typedef void(^OffcnIMChatInfoHeadIconClickCallBack)(OffcnIMChatInfoType event,NSString *userID);

@interface OffcnIMSDKiOS : NSObject

//返回单例对象
+ (OffcnIMSDKiOS *)defaultService;

// 后台所有下载任务完成回调
@property (nonatomic, copy) void (^backgroundSessionCompletionHandler)(void);


//是否选用测试环境
@property (nonatomic, assign) BOOL isTest;

//deviceToken
@property (nonatomic, copy) NSString *deviceToken;

//网络状态
@property (nonatomic, assign) OffcnIMSDKReachabilityStatus OffcnReachabilityStatus;
@property (nonatomic, copy) OffcnIMSDKReachabilityStatusCallBack reachabilityStatusCallBack;

//聊天详情头像点击事件回调
@property (nonatomic, copy) OffcnIMChatInfoHeadIconClickCallBack chatInfoHeadIconClickCallBack;



/// 启动SDK
/// @param isTest 是否选用测试环境
/// @param appkey 创建APP时获取的appkey
/// @param appsecret 创建APP时获取的appsecret
-(void)setupWithIsTest:(BOOL)isTest appkey:(NSString *)appkey appsecret:(NSString *)appsecret;


/// 获取用户未读消息总数
/// @param accid 用户账号id
/// @param finished 结果回调
-(void)getUserAllUnreadNumberWithAccid:(NSString *)accid Finished:(void(^)(BOOL success,NSInteger total_unread_number,NSString *errorMessage))finished;


/// 发送消息
/// @param msg_fromID 发送人ID
/// @param msg_toID 接收人ID
/// @param msg_type 发送消息类型
/// @param text 文本
/// @param filePath 图片/音频（语音消息格式，只能是aac格式）/视频/文件，沙盒路径
/// @param ext 开发者扩展字段
/// @param extIndex 开发者扩展字段
/// @param repeatSend_tid 重新发送的tid
/// @param finished 结果回调，最大限制为500字，超过500字报错回调信息：超过500字
/// @param progressPercent 进度回调
/// @param tidStrFinished 发送消息本地tid回调
-(void)sendMsgWithMsg_fromID:(NSString *)msg_fromID msg_toID:(NSString *)msg_toID msg_type:(OffcnSDKMsgType)msg_type text:(NSString *)text filePath:(NSString *)filePath ext:(NSString *)ext extIndex:(NSString *)extIndex repeatSend_tid:(NSString *)repeatSend_tid Finished:(void(^)(NSString *extIndex,BOOL success,OffcnIMBodyModel *sendMsgModel,NSString *errorMessage))finished ProgressPercent:(void(^)(NSString *extIndex, NSString *filePath, float percent))progressPercent tidStrFinished:(void(^)(NSString *extIndex,NSString *tidString))tidStrFinished;

/// 用户信息标记已读
/// @param msg_fromID 发送人ID
/// @param msg_toID 接收人ID
/// @param msg_seq 消息时序
/// @param finished 结果回调
-(void)markMsgReadWithMsg_fromID:(NSString *)msg_fromID msg_toID:(NSString *)msg_toID msg_seq:(NSInteger)msg_seq Finished:(void(^)(BOOL success,id response,NSString *errorMessage))finished;

/// 获取会话未读消息列表
/// @param fromID 发送人ID
/// @param toID 接收人ID
/// @param finished 结果回调
-(void)getSessionUnreadMsgWithFromID:(NSString *)fromID toID:(NSString *)toID Finished:(void(^)(BOOL success,OffcnIMUnreadMsgModel *unreadMsgModel,NSString *errorMessage))finished;

/// 获取会话历史消息列表
/// @param fromID 发送人ID
/// @param toID 接收人ID
/// @param msg_seq 消息时序
/// @param finished 结果回调
-(void)getSessionHistoryMsgWithFromID:(NSString *)fromID toID:(NSString *)toID msg_seq:(NSString *)msg_seq Finished:(void(^)(BOOL success,OffcnIMHistoryMsgModel *historyMsgModel,NSString *errorMessage))finished;


/// 获取用户最近会话记录
/// @param accid 被获取用户id
/// @param finished 结果回调
-(void)getRecentSessionsWithAccid:(NSString *)accid Finished:(void(^)(BOOL success,OffcnIMHistoryMsgModel *historyMsgModel,NSString *errorMessage))finished;

/// 设置会话置顶
/// @param accid 用户ID
/// @param toID 联系人用户ID
/// @param finished 结果回调
-(void)setSessionTopWithAccid:(NSString *)accid toID:(NSString *)toID Finished:(void(^)(BOOL success,NSString *errorMessage))finished;

/// 取消会话置顶
/// @param accid 用户ID
/// @param toID 联系人用户ID
/// @param finished 结果回调
-(void)setCancelSessionTopWithAccid:(NSString *)accid toID:(NSString *)toID Finished:(void(^)(BOOL success,NSString *errorMessage))finished;


/// 接口注册推送
/// @param accid 用户ID
/// @param device_token 设备Token
/// @param finished 结果回调
-(void)registerDevicesWithAccid:(NSString *)accid device_token:(NSData *)device_token Finished:(void(^)(BOOL success,id response,NSString *errorMessage))finished;

/// 接口注销推送
/// @param accid 用户ID
/// @param device_token 设备Token
/// @param finished 结果回调
-(void)unregisterDevicesWithAccid:(NSString *)accid device_token:(NSString *)device_token Finished:(void(^)(BOOL success,id response,NSString *errorMessage))finished;

/// 取消所有请求
-(void)cancelAllOperations;

/// 登陆账号
-(void)login;

/// 退出账号
-(void)logout;



/// 获取私聊会话列表
/// @param finished 结果回调
-(void)get_privateMessage_listFinished:(void(^)(BOOL success,id response,NSString *errorMessage))finished;

/// 获取私聊会话历史
/// @param msg_to 对方ID
/// @param lastId 最后一条消息ID
/// @param room_num 房间号
/// @param finished 结果回调
-(void)get_privateMessage_historyWithMsg_to:(NSString *)msg_to lastId:(NSString *)lastId room_num:(NSString *)room_num Finished:(void(^)(BOOL success,id response,NSString *errorMessage))finished;

/// 更新私聊会话状态
/// @param msg_to 对方ID
/// @param last_id 最后一条消息ID
/// @param room_num 房间号
/// @param finished 结果回调
-(void)post_privateMessage_statusWithMsg_to:(NSString *)msg_to last_id:(NSString *)last_id room_num:(NSString *)room_num Finished:(void(^)(BOOL success,id response,NSString *errorMessage))finished;

/// 私聊发送消息
/// @param msg_to 对方ID
/// @param content 内容
/// @param room_num 房间号
/// @param finished 结果回调
-(void)post_privateMessageWithMsg_to:(NSString *)msg_to content:(NSMutableArray *)content room_num:(NSString *)room_num Finished:(void(^)(BOOL success,id response,NSString *errorMessage))finished;

/// 发送私聊消息
/// @param msg_to 接收人ID
/// @param room_num 房间号
/// @param msg_type 发送消息类型
/// @param text 文本
/// @param filePath 图片/音频（语音消息格式，只能是aac格式）/视频/文件，沙盒路径
/// @param ext 开发者扩展字段
/// @param extIndex 开发者扩展字段
/// @param repeatSend_tid 重新发送的tid
/// @param finished 结果回调，最大限制为500字，超过500字报错回调信息：超过500字
/// @param progressPercent 进度回调
/// @param tidStrFinished 发送消息本地tid回调
-(void)sendPrivateMsgWithMsg_to:(NSString *)msg_to room_num:(NSString *)room_num msg_type:(OffcnSDKMsgType)msg_type text:(NSMutableAttributedString *)text filePath:(NSString *)filePath ext:(NSString *)ext extIndex:(NSString *)extIndex repeatSend_tid:(NSString *)repeatSend_tid Finished:(void(^)(NSString *extIndex,BOOL success, id response, NSMutableArray *content, NSString *errorMessage))finished ProgressPercent:(void(^)(NSString *extIndex, NSString *filePath, float percent))progressPercent tidStrFinished:(void(^)(NSString *extIndex,NSString *tidString))tidStrFinished;


//清除本地关于下载文件的缓存
- (void)clearLocalCache;


//********************************************客服接口********************************************

/// 客服-发送消息
/// @param msg_fromID 发送人ID
/// @param msg_toID 接收人ID
/// @param group_id 客服组ID
/// @param is_agent 是否教师身份登陆
/// @param msg_type 发送消息类型
/// @param text 文本
/// @param filePath 图片/音频（语音消息格式，只能是aac格式）/视频/文件，沙盒路径
/// @param ext 开发者扩展字段
/// @param extIndex 开发者扩展字段
/// @param repeatSend_tid 重新发送的tid
/// @param finished 结果回调，最大限制为500字，超过500字报错回调信息：超过500字
/// @param progressPercent 进度回调
/// @param tidStrFinished 发送消息本地tid回调
-(void)cs_sendMsgWithMsg_fromID:(NSString *)msg_fromID msg_toID:(NSString *)msg_toID group_id:(NSString *)group_id is_agent:(BOOL)is_agent msg_type:(OffcnSDKMsgType)msg_type text:(NSString *)text filePath:(NSString *)filePath ext:(NSString *)ext extIndex:(NSString *)extIndex repeatSend_tid:(NSString *)repeatSend_tid Finished:(void(^)(NSString *extIndex,BOOL success,OffcnIMBodyModel *sendMsgModel,NSString *errorMessage))finished ProgressPercent:(void(^)(NSString *extIndex, NSString *filePath, float percent))progressPercent tidStrFinished:(void(^)(NSString *extIndex,NSString *tidString))tidStrFinished;

/// 客服-获取用户最近会话记录
/// @param accid 被获取用户id
/// @param finished 结果回调
-(void)cs_getRecentSessionsWithAccid:(NSString *)accid Finished:(void(^)(BOOL success,OffcnIMHistoryMsgModel *historyMsgModel,NSString *errorMessage))finished;

/// 客服-用户信息标记已读
/// @param accid 教师ID
/// @param customer_id 学生ID
/// @param group_id 客户组ID
/// @param finished 结果回调
-(void)cs_markMsgReadWithAccid:(NSString *)accid customer_id:(NSString *)customer_id group_id:(NSString *)group_id Finished:(void(^)(BOOL success,id response,NSString *errorMessage))finished;

/// 客服-获取在线状态数据
/// @param accid 登陆用户ID
/// @param finished 结果回调
-(void)cs_getAgent_statusWithAccid:(NSString *)accid Finished:(void(^)(BOOL success,OffcnIMCSAutoreplyModel *statusModel,NSString *errorMessage))finished;

/// 客服-获取会话历史消息
/// @param fromID 发送人ID
/// @param toID 接收人ID
/// @param is_agent 是否客服登陆
/// @param group_id 客服组ID
/// @param msg_seq 消息时序
/// @param finished 结果回调
-(void)cs_getSessionHistoryMsgWithFromID:(NSString *)fromID toID:(NSString *)toID is_agent:(BOOL)is_agent group_id:(NSString *)group_id msg_seq:(NSString *)msg_seq Finished:(void(^)(BOOL success,OffcnIMHistoryMsgModel *historyMsgModel,NSString *errorMessage))finished;

/// 客服-获取用户未读消息总数
/// @param accid 登陆用户ID
/// @param finished 结果回调
-(void)cs_getUserAllUnreadNumberWithAccid:(NSString *)accid Finished:(void(^)(BOOL success,NSInteger total_unread_number,NSString *errorMessage))finished;
@end
