//
//  OffcnIMZYJ1FMDBHandler.h
//  OffcnIMSDKiOS
//
//  Created by vockey on 2019/4/9.
//  Copyright © 2019年 中公教育. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, UIClearStyle) {
    UIClearStyleAll     = 1,//删除list和具体聊天内容
    UIClearStylePart    = 2,//只删除聊天内容 , list记录不删除
    UIClearStyleList    = 3 //删除系统消息等
};

@class OffcnIMBodyModel;
typedef void (^getFMDBHistoryMessagesBlock)(NSArray<OffcnIMBodyModel *> *messagesArray);
typedef void (^getFMDBOneMessageBlock)(OffcnIMBodyModel *model);
typedef void (^callBackIsSuccess)(BOOL isSuccess);


@interface OffcnIMZYJ1FMDBHandler : NSObject

//单例
+ (OffcnIMZYJ1FMDBHandler *)sharedInstance;

//获取用户相关数据库，该方法在登陆或者第一次启动已登陆下执行
- (void)getUserDB;

//发送,收到消息写入
//- (void)insertChatInfoToFMDBWithModel:(OffcnIMBodyModel *)chatModel;

//拉取更新消息列表
- (void)updateChatInfoCacheInfo:(OffcnIMBodyModel *)chatModel callback:(callBackIsSuccess)isSucess;

//消息发送成功更新状态
//- (void)updateChatInfoIsSendStatusToFMDBWithModel:(OffcnIMBodyModel *)messageModel isSuccess:(callBackIsSuccess)isSuccess;

//自己发送消息更新聊天列表
- (void)chatlistCacheInfo:(OffcnIMBodyModel *)chatlistModel callback:(callBackIsSuccess)isSucess;

//拉取更新聊天列表
- (void)updateChatlistCacheInfo:(OffcnIMBodyModel *)chatlistModel callback:(callBackIsSuccess)isSucess;

//更新和某个用户所有聊天为已读状态
- (void)updateChatInfoIsRead:(OffcnIMBodyModel *)model callBack:(callBackIsSuccess)isSuccess;
//更新和某个用户的聊天和未读数
- (void)updateChatListUnread_number:(OffcnIMBodyModel *)model callBack:(getFMDBOneMessageBlock)messagesBack;
//更新和某个用户的未读数
- (void)updateChatListOnlyUnread_number:(NSInteger)unread_number fromUser:(NSString *)fromUser toUser:(NSString *)toUser callBack:(void(^)(NSInteger unread_number,NSString *fromUser,NSString *toUser))numberBack;

/// 删除个人聊天记录
/// @param fromUser 发送人ID
/// @param toUser 接收人ID
/// @param clearStyle 删除类型
/// @param callbackBool 结果回调
- (void)deleteUserChatDataWithFromUser:(NSString *)fromUser toUser:(NSString *)toUser clearStyle:(UIClearStyle)clearStyle callBack:(callBackIsSuccess)callbackBool;

/// 删除消息,并更新消息列表最后一条消息
/// @param messageModel 要删除的一条消息
/// @param array 被删除消息所在的数组，数组会移除这条消息
/// @param isSuccess 结果回调
- (void)deleteMessage:(OffcnIMBodyModel *)messageModel dataSource:(NSMutableArray<OffcnIMBodyModel *> *)array callback:(callBackIsSuccess)isSuccess;

/// 查询聊天记录(按时间戳升序排序)
/// @param fromUser 发送人ID
/// @param toUser 接收人ID
/// @param limit 消息数量
/// @param startIndex 从第几条消息开始
/// @param messagesBack 结果回调
- (void)getChatRecordArrayWithFromUser:(NSString *)fromUser toUser:(NSString *)toUser limit:(NSString *)limit startIndex:(NSString *)startIndex callback:(getFMDBHistoryMessagesBlock)messagesBack;

//查询聊天列表(按时间戳倒叙排序)
- (void)getChatListArrayWithFromUser:(NSString *)fromUser Callback:(getFMDBHistoryMessagesBlock)messagesBack;
//查询聊天列表其中一个会话信息
- (void)getChatListOneMessageWithFromUser:(NSString *)fromUser toUser:(NSString *)toUser callback:(getFMDBOneMessageBlock)messagesBack;

//查询某条消息是否存在
- (void)queryAMessageExistsWithMegid:(NSString *)megid callback:(getFMDBHistoryMessagesBlock)messagesBack;


//消息内容
- (NSString *)lastMessage:(OffcnIMBodyModel *)messageModel;

//删除表格
- (void)deleteDataTable;
@end

