//
//  OffcnIMSDKiOS.h
//  OffcnIMSDKiOS
//
//  Created by vockey on 2018/10/16.
//  Copyright © 2018年 中公教育. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "OffcnIMModel.h"

static const NSString *OffcnIMSDKiOSVersion = @"1.0.0.21";

typedef NS_ENUM(NSUInteger, OffcnIMSDKReachabilityStatus) {
    OffcnIMSDKReachabilityStatusNotReachable = 0,
    OffcnIMSDKReachabilityStatusViaWWAN,
    OffcnIMSDKReachabilityStatusViaWiFi,
};

typedef NS_ENUM(NSUInteger, OffcnSDKMsgType) {
    OffcnSDKMsgTypeText = 1, //文本消息
    OffcnSDKMsgTypePicture,  //图片消息
    OffcnSDKMsgTypeAudio,    //音频消息
    OffcnSDKMsgTypeVideo,    //视频消息
    OffcnSDKMsgTypeFile,     //文件消息
};

typedef NS_ENUM(NSUInteger, OffcnSDKMsgScope) {
    OffcnSDKMsgScopeSingleChat = 1, //单聊消息
    OffcnSDKMsgScopeGroupChat,      //群聊消息
};

typedef NS_ENUM(NSUInteger, OffcnSDKType) {
    OffcnSDKTypeIM = 1, //IM 消息
};

//网络监听回调
typedef void(^OffcnIMSDKReachabilityStatusCallBack)(OffcnIMSDKReachabilityStatus status);

@interface OffcnIMSDKiOS : NSObject

//返回单例对象
+ (OffcnIMSDKiOS *)defaultService;

//是否选用测试环境
@property (nonatomic, assign) BOOL isTest;

//deviceToken
@property (nonatomic, copy) NSString *deviceToken;

//网络状态
@property (nonatomic, assign) OffcnIMSDKReachabilityStatus OffcnReachabilityStatus;
@property (nonatomic, copy) OffcnIMSDKReachabilityStatusCallBack reachabilityStatusCallBack;


/// 启动SDK
/// @param isTest 是否选用测试环境
/// @param appkey 创建APP时获取的appkey
/// @param appsecret 创建APP时获取的appsecret
-(void)setupWithIsTest:(BOOL)isTest appkey:(NSString *)appkey appsecret:(NSString *)appsecret;


/// 获取用户未读消息总数
/// @param accid 用户账号id
/// @param finished 结果回调
-(void)getUserAllUnreadNumberWithAccid:(NSString *)accid Finished:(void(^)(BOOL success,NSInteger total_unread_number,NSString *errorMessage))finished;

/// 发送消息
/// @param msg_fromID 发送人ID
/// @param msg_toID 接收人ID
/// @param msg_type 发送消息类型
/// @param text 文本
/// @param filePath 图片/音频（语音消息格式，只能是aac格式）/视频/文件，沙盒路径
/// @param ext 开发者扩展字段
/// @param extIndex 开发者扩展字段
/// @param finished 结果回调，最大限制为500字，超过500字报错回调信息：超过500字
-(void)sendMsgWithMsg_fromID:(NSString *)msg_fromID msg_toID:(NSString *)msg_toID msg_type:(OffcnSDKMsgType)msg_type text:(NSString *)text filePath:(NSString *)filePath ext:(NSString *)ext extIndex:(NSString *)extIndex Finished:(void(^)(NSString *extIndex,BOOL success,OffcnIMBodyModel *sendMsgModel,NSString *errorMessage))finished ProgressPercent:(void(^)(NSString *extIndex, NSString *filePath, float percent))progressPercent;

/// 用户信息标记已读
/// @param msg_fromID 发送人ID
/// @param msg_toID 接收人ID
/// @param msg_seq 消息时序
/// @param finished 结果回调
-(void)markMsgReadWithMsg_fromID:(NSString *)msg_fromID msg_toID:(NSString *)msg_toID msg_seq:(NSInteger)msg_seq Finished:(void(^)(BOOL success,id response,NSString *errorMessage))finished;

/// 获取会话未读消息列表
/// @param fromID 发送人ID
/// @param toID 接收人ID
/// @param finished 结果回调
-(void)getSessionUnreadMsgWithFromID:(NSString *)fromID toID:(NSString *)toID Finished:(void(^)(BOOL success,OffcnIMUnreadMsgModel *unreadMsgModel,NSString *errorMessage))finished;

/// 获取会话历史消息列表
/// @param fromID 发送人ID
/// @param toID 接收人ID
/// @param msg_seq 消息时序
/// @param finished 结果回调
-(void)getSessionHistoryMsgWithFromID:(NSString *)fromID toID:(NSString *)toID msg_seq:(NSString *)msg_seq Finished:(void(^)(BOOL success,OffcnIMHistoryMsgModel *historyMsgModel,NSString *errorMessage))finished;


/// 获取用户最近会话记录
/// @param accid 被获取用户id
/// @param finished 结果回调
-(void)getRecentSessionsWithAccid:(NSString *)accid Finished:(void(^)(BOOL success,OffcnIMHistoryMsgModel *historyMsgModel,NSString *errorMessage))finished;

/// 设置会话置顶
/// @param accid 用户ID
/// @param toID 联系人用户ID
/// @param finished 结果回调
-(void)setSessionTopWithAccid:(NSString *)accid toID:(NSString *)toID Finished:(void(^)(BOOL success,NSString *errorMessage))finished;

/// 取消会话置顶
/// @param accid 用户ID
/// @param toID 联系人用户ID
/// @param finished 结果回调
-(void)setCancelSessionTopWithAccid:(NSString *)accid toID:(NSString *)toID Finished:(void(^)(BOOL success,NSString *errorMessage))finished;


/// 接口注册推送
/// @param accid 用户ID
/// @param device_token 设备Token
/// @param finished 结果回调
-(void)registerDevicesWithAccid:(NSString *)accid device_token:(NSData *)device_token Finished:(void(^)(BOOL success,id response,NSString *errorMessage))finished;

/// 接口注销推送
/// @param accid 用户ID
/// @param device_token 设备Token
/// @param finished 结果回调
-(void)unregisterDevicesWithAccid:(NSString *)accid device_token:(NSString *)device_token Finished:(void(^)(BOOL success,id response,NSString *errorMessage))finished;


/// 登陆账号
-(void)login;

/// 退出账号
-(void)logout;
@end
