//
//  OffcnIMModel.h
//  OffcnIMSDKiOS
//
//  Created by vockey on 2020/8/25.
//  Copyright © 2020 offcn. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class OffcnIMBodyModel;
@interface OffcnIMModel : NSObject

@property (nonatomic,assign)NSInteger type;//报文类型,1:IM 消息
@property (nonatomic,strong)OffcnIMBodyModel *body;
@end

@class OffcnIMMsgModel;
@interface OffcnIMBodyModel : NSObject

@property (nonatomic,assign)BOOL is_top;//是否置顶
@property (nonatomic,copy)NSString *session_id; //会话ID
@property (nonatomic,copy)NSString *msg_id;//消息Id
@property (nonatomic,copy)NSString *version;
@property (nonatomic,copy)NSString *send_time;//发送时间
@property (nonatomic,assign)NSInteger msg_seq;//消息时序
@property (nonatomic,assign)NSInteger msg_scope;// 区分单聊：1以及群聊：2
@property (nonatomic,copy)NSString *msg_from;//发送消息的用户id
@property (nonatomic,copy)NSString *msg_to;//接受消息的用户id
@property (nonatomic,copy)NSString *to;//对方Id
@property (nonatomic,assign)NSInteger msg_type;//消息类型
@property (nonatomic,strong)OffcnIMMsgModel *msg;//消息内容

@property (nonatomic,assign)BOOL isJoinSession;//

@property (nonatomic,copy)NSString *extIndex;//开发者扩展字段
@property (nonatomic,copy)NSString *ext;//开发者扩展字段
@property (nonatomic,assign)CGFloat cellH;//扩展字段

//以下数据库使用
@property (nonatomic,assign)NSInteger isSentSuccess;//是否发送成功
@property (nonatomic,assign)NSInteger bymyself;//是否是我发送的
@property (nonatomic,assign)NSInteger isRead;//是否已读
@property (nonatomic,copy)NSString *lastmessage;//最后一条消息
@property (nonatomic,copy)NSString *lastSendtime;//最后一条消息时间
@property (nonatomic,copy)NSString *tid;//本地的消息Id
@property (nonatomic,assign)BOOL isGroupSendMsg;//是否群发消息
@property (nonatomic,assign)NSInteger unread_number;//每个会话的未读数
@property (nonatomic,assign)NSInteger total_unread_number;//所有会话总未读数
@end

@interface OffcnIMMsgModel : NSObject

@property (nonatomic,copy)NSString *msg;//文本消息内容

@property (nonatomic,assign)NSInteger dur;//只有音频消息和视频消息返回的时长ms
@property (nonatomic,copy)NSString *name;//只有图片消息和文件消息返回的名字
@property (nonatomic,copy)NSString *md5;//md5
@property (nonatomic,copy)NSString *url;//下载地址
@property (nonatomic,copy)NSString *thumb_url;//只有图片消息返回的缩略图URL
@property (nonatomic,copy)NSString *cover_url;//只有视频消息返回的视频封面url
@property (nonatomic,copy)NSString *ext;//文件类型
@property (nonatomic,assign)NSInteger w;//宽
@property (nonatomic,assign)NSInteger h;//高
@property (nonatomic,assign)NSInteger size;//文件大小
@end

//发送消息Model
@interface OffcnIMSendMsgModel : NSObject

@property (nonatomic,copy)NSString *msg_id;//消息Id
@property (nonatomic,copy)NSString *send_time;//发送时间
@property (nonatomic,copy)NSString *session_id; //会话ID
@property (nonatomic,copy)NSString *tid;//本地的消息Id
@end

//获取会话未读消息列表Model
@interface OffcnIMUnreadMsgModel : NSObject

@property (nonatomic,copy)NSString *version;
@property (nonatomic,copy)NSString *lrms;//用户关于当前会话最后已读的消息序列号
@property (nonatomic,strong)NSMutableArray *msg_list;
@end


//获取用户最近会话记录Model
@interface OffcnIMRecentMsgModel : NSObject

@property (nonatomic,strong)NSMutableArray *sessions;
@end

@class OffcnIMLast_msgModel;
@interface OffcnIMSessionModel : NSObject

@property (nonatomic,assign)BOOL is_top;//是否置顶
@property (nonatomic,strong)OffcnIMLast_msgModel *last_msg;//消息信息
@property (nonatomic,copy)NSString *session_id;//会话Id
@property (nonatomic,copy)NSString *to;//对方Id
@property (nonatomic,assign)NSInteger type;//类型
@property (nonatomic,assign)NSInteger unread_number;//数量
@end

@interface OffcnIMLast_msgModel : NSObject

@property (nonatomic,copy)NSString *ext;//开发者扩展字段
@property (nonatomic,strong)OffcnIMMsgModel *msg;//消息内容
@property (nonatomic,assign)NSInteger msg_type;//消息类型
@property (nonatomic,copy)NSString *send_time;//时间
@property (nonatomic,copy)NSString *session_id; //会话ID
@property (nonatomic,copy)NSString *msg_id;//消息Id
@property (nonatomic,copy)NSString *version;
@property (nonatomic,assign)NSInteger msg_seq;//消息时序
@property (nonatomic,assign)NSInteger msg_scope;// 区分单聊：1以及群聊：2
@property (nonatomic,copy)NSString *msg_from;//发送消息的用户id
@property (nonatomic,copy)NSString *msg_to;//接受消息的用户id
@property (nonatomic,copy)NSString *to;//对方Id
@end

//获取会话历史消息列表Model
@interface OffcnIMHistoryMsgModel : NSObject

@property (nonatomic,copy)NSString *version;
@property (nonatomic,strong)NSMutableArray *msg_list;
@end


//推送Model
@class OffcnIMPushApsModel;
@interface OffcnIMPushModel : NSObject

@property (nonatomic,strong)OffcnIMModel *message;
@property (nonatomic,strong)OffcnIMPushApsModel *aps;
@end

@interface OffcnIMPushApsModel : NSObject

@property (nonatomic,strong)NSDictionary *alert;
@property (nonatomic,copy)NSString *badge;
@property (nonatomic,copy)NSString *sound;
@end


//IM基础配置
@interface OffcnIMSettingsGatewayModel : NSObject

@property (nonatomic,copy)NSString *server_ip;
@property (nonatomic,assign)NSInteger server_port_kcp;
@property (nonatomic,assign)NSInteger server_port_ws;
@property (nonatomic,assign)NSInteger server_port_wss;
@end

@interface OffcnIMSettingsModel : NSObject

@property (nonatomic,strong)OffcnIMSettingsGatewayModel *gateway;
@end



NS_ASSUME_NONNULL_END
