//
//  OffcnIMPrivateChatListViewController.h
//  OffcnIMSDKiOSDemo
//
//  Created by vockey on 2021/4/8.
//  Copyright © 2021 offcn. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "OffcnIMModel.h"

NS_ASSUME_NONNULL_BEGIN

//消息总数回调
typedef void(^OffcnIMPrivateChatTotal_unread_number)(NSInteger num);

@interface OffcnIMPrivateChatListViewController : UIViewController

@property (nonatomic, copy) OffcnIMPrivateChatTotal_unread_number privateChatTotal_unread_number;//消息总数回调

//返回联系人信息--userID为用户登陆ID；room_num为房间号
-(OffcnIMUserList_listModel *)getPrivateChatContactInfoModelWithUserID:(NSString *)userID room_num:(NSString *)room_num;

//清空数据
-(void)clearData;

//刷新（不调用接口）
-(void)reloadData;

//下拉刷新效果（调用接口）
-(void)beginRefreshing;

//获取用户最近会话记录（调用接口刷新）
- (void)getRecentVChatFinished:(void(^)(BOOL success))finished;

@end

NS_ASSUME_NONNULL_END
