<?php

use Illuminate\Support\Facades\Route;

// 账户管理
Route::group(['prefix'=> 'account'], function () {
    // 小程序-获取钱包的开关状态
    Route::get('open/info', ['uses' => 'AccountController@getAccountOpenInfo', 'label' => '我的钱包', 'description' => '获取钱包的开关状态']);

    // 小程序-获取我的钱包详情
    Route::get('info', ['uses' => 'AccountController@getAccountInfo', 'label' => '我的钱包', 'description' => '获取我的钱包详情']);

    // 小程序-提交充值申请
    Route::post('apply', ['uses' => 'AccountController@applyRecharge', 'label' => '我的钱包', 'description' => '提交充值申请']);

    // admin-获取充值申请列表
    Route::get('list', ['uses' => 'AccountController@getAccountList', 'label' => '我的钱包', 'description' => '获取充值申请列表']);

    // admin-充值申请审核
    Route::post('apply/check', ['uses' => 'AccountController@applyCheck', 'label' => '我的钱包', 'description' => '充值申请审核']);

    // admin-充值
    Route::post('recharge', ['uses' => 'AccountController@accountRecharge', 'label' => '我的钱包', 'description' => '充值']);

    // admin-查看充值转账详情
    Route::get('record', ['uses' => 'AccountController@getAccountRecord', 'label' => '我的钱包', 'description' => '查看充值转账详情']);

    // 小程序-转账
    Route::post('transfer', ['uses' => 'AccountController@accountTransfer', 'label' => '我的钱包', 'description' => '转账']);

    // 小程序-查询我的快递
    Route::get('express/list', ['uses' => 'AccountController@getExpressList', 'label' => '我的钱包', 'description' => '查询我的快递']);

});

// 小程序-获取客服的开关状态
Route::get('service/open/info', ['uses' => 'AccountController@getServiceOpenInfo', 'label' => '客服', 'description' => '获取客服的开关状态']);


// 发送短信验证码
Route::post('sms/send', ['uses' => 'AccountController@smsCodeSend', 'label' => '短信服务', 'description' => '发送短信验证码']);

// DeepSeek
Route::group(['prefix'=> 'ds'], function () {
    // 对话补全
    Route::post('chat/completions', ['uses' => 'AccountController@getDSChatCompletions', 'label' => 'DS', 'description' => '对话补全']);


});


