<?php

use Illuminate\Support\Facades\Route;

// 订单管理
Route::group(['prefix'=> 'order'], function () {
    // 提交订单
    Route::post('add', ['uses' => 'OrderController@addOrder', 'label' => '订单管理', 'description' => '提交订单']);

    // 获取订单课程列表(前台, 订单详情即课程快照数据已在本接口返回)
    Route::get('course/list', ['uses' => 'OrderController@getOrderCourseList', 'label' => '订单管理', 'description' => '获取订单课程列表']);

    // 获取订单列表/导出(后台)
    Route::get('list', ['uses' => 'OrderController@getOrderList', 'label' => '订单管理', 'description' => '获取订单信息']);

    // 查看订单详情(后台)
    Route::get('info', ['uses' => 'OrderController@getOrderInfo', 'label' => '订单管理', 'description' => '查看订单详情']);

    // 更新订单物流信息
    Route::post('express', ['uses' => 'OrderController@updateOrderExpress', 'label' => '订单管理', 'description' => '更新订单物流信息']);

    // 更新接待人信息
    Route::post('reception', ['uses' => 'OrderController@updateOrderReception', 'label' => '订单管理', 'description' => '更新订单物流信息']);

    // 驳回订单
    Route::post('reject', ['uses' => 'OrderController@orderReject', 'label' => '订单管理', 'description' => '驳回订单']);

    // 上传协议(后台)
    Route::post('protocol', ['uses' => 'OrderController@uploadProtocol', 'label' => '订单管理', 'description' => '上传协议']);

    // 撤回订单
    Route::post('cancel', ['uses' => 'OrderController@orderCancel', 'label' => '订单管理', 'description' => '撤回订单']);

    // 获取我的协议
    Route::get('protocol', ['uses' => 'OrderController@getProtocolList', 'label' => '订单管理', 'description' => '获取我的协议']);

    // 推送协议
    Route::post('protocol/push', ['uses' => 'OrderController@orderProtocolPush', 'label' => '订单管理', 'description' => '推送协议']);

    // 协议审核操作
    Route::post('protocol/check', ['uses' => 'OrderController@orderProtocolCheck', 'label' => '订单管理', 'description' => '协议审核操作']);

    // 订单删除,支持批量
    Route::post('delete', ['uses' => 'OrderController@deleteOrders', 'label' => '订单管理', 'description' => '撤回订单']);

    // 订单类型修改
    Route::post('release', ['uses' => 'OrderController@orderRelease', 'label' => '订单管理', 'description' => '订单类型修改']);

    // 修改订单沟通情况
    Route::post('communication', ['uses' => 'OrderController@orderCommunication', 'label' => '订单管理', 'description' => '修改订单沟通情况']);

});


// 快递
Route::group(['prefix'=> 'express'], function () {
    // 查看我的快递
    Route::get('list', ['uses' => 'OrderController@getExpressList', 'label' => '快递管理', 'description' => '查看我的快递']);

});


// 交易记录管理
Route::group(['prefix'=> 'deal'], function () {
    // 新增交易记录
    Route::post('add', ['uses' => 'OrderController@addDeal', 'label' => '交易记录管理', 'description' => '新增交易记录']);

    // 获取交易记录列表/导出
    Route::get('list', ['uses' => 'OrderController@getDealList', 'label' => '交易记录管理', 'description' => '获取交易记录列表']);

    // 获取交易记录详情
    Route::get('info', ['uses' => 'OrderController@getDealInfo', 'label' => '交易记录管理', 'description' => '获取交易记录详情']);

    // 编辑保存交易记录
    Route::post('update', ['uses' => 'OrderController@updateDeal', 'label' => '交易记录管理', 'description' => '编辑保存交易记录']);

    // 删除交易记录(支持批量)
    Route::post('delete', ['uses' => 'OrderController@deleteDeal', 'label' => '交易记录管理', 'description' => '删除交易记录(支持批量)']);

    // 设置交易记录无效(支持批量)
    Route::post('invalid', ['uses' => 'OrderController@setDealInvalid', 'label' => '交易记录管理', 'description' => '设置交易记录无效(支持批量)']);

    // 设置系统状态(支持批量)
    Route::post('system_status', ['uses' => 'OrderController@setDealSystemStatus', 'label' => '交易记录管理', 'description' => '设置系统状态(支持批量)']);

    // 交易记录审核/驳回(支持批量)
    Route::post('check', ['uses' => 'OrderController@checkDeal', 'label' => '交易记录管理', 'description' => '交易记录审核/驳回(支持批量)']);

    // 交易记录导入
    Route::post('import', ['uses' => 'OrderController@importDeal', 'label' => '交易记录管理', 'description' => '交易记录导入']);

    // 校验协议单号
    Route::post('check/order', ['uses' => 'OrderController@checkProtocolOrder', 'label' => '交易记录管理', 'description' => '校验协议单号']);

    // 更新交易记录的协议
    Route::post('protocol/update', ['uses' => 'OrderController@updateDealRecordProtocol', 'label' => '交易记录管理', 'description' => '更新交易记录的协议']);

    // 快递单号导入
    Route::post('express/import', ['uses' => 'OrderController@importDealExpress', 'label' => '交易记录管理', 'description' => '快递单号导入']);

    // 更新商品快递单号
    Route::post('express/update', ['uses' => 'OrderController@updateDealExpress', 'label' => '交易记录管理', 'description' => '更新商品快递单号']);

    // 提交审核(支持批量)
    Route::post('submit/check', ['uses' => 'OrderController@dealSubmitCheck', 'label' => '交易记录管理', 'description' => '提交审核(支持批量)']);

    // 标记状态导入
    Route::post('system_status/import', ['uses' => 'OrderController@importSystemStatus', 'label' => '交易记录管理', 'description' => '标记状态导入']);

    // 15天内未发货商品列表
    Route::get('goods/not_deliver/list', ['uses' => 'OrderController@getGoodsNotDeliverList', 'label' => '交易记录管理', 'description' => '15天内未发货商品列表']);

    // 统计相关
    // 成交情况汇总
    Route::get('statistics', ['uses' => 'OrderController@getDealStatistics', 'label' => '交易记录管理', 'description' => '成交情况汇总']);

    // 商品分类统计
    Route::get('goods/statistics', ['uses' => 'OrderController@getDealGoodsStatistics', 'label' => '交易记录管理', 'description' => '商品分类统计']);

    // 分校成交情况汇总
    Route::get('branch/statistics', ['uses' => 'OrderController@getDealBranchStatistics', 'label' => '交易记录管理', 'description' => '分校成交情况汇总']);

    // 商品分类分部门统计
    Route::get('goods/department/statistics', ['uses' => 'OrderController@getGoodsDepartmentStatistics', 'label' => '交易记录管理', 'description' => '商品分类分部门统计']);

});


// 商品管理
Route::group(['prefix'=> 'goods'], function () {
    // 新增商品
    Route::post('add', ['uses' => 'OrderController@addGoods', 'label' => '商品管理', 'description' => '新增商品']);

    // 获取商品列表/导出
    Route::get('list', ['uses' => 'OrderController@getGoodsList', 'label' => '商品管理', 'description' => '获取商品列表']);

    // 商品禁用/启用
    Route::post('status', ['uses' => 'OrderController@updateGoodsStatus', 'label' => '商品管理', 'description' => '商品禁用/启用']);

    // 商品导入
    Route::post('import', ['uses' => 'OrderController@importGoods', 'label' => '商品管理', 'description' => '商品导入']);

    // 编辑商品成本价
    Route::post('price', ['uses' => 'OrderController@editGoodsPrice', 'label' => '商品管理', 'description' => '编辑商品成本价']);

    // 商品关联小程序/修改售价
    Route::post('related', ['uses' => 'OrderController@goodsRelatedApplet', 'label' => '商品管理', 'description' => '商品关联小程序/修改售价']);

});