<?php

namespace App\Http\Services;
use App\Models\Config;
use App\Models\ParentsIntention;
use App\Models\StudentPreferenceMajor;
use Exception;
use Illuminate\Support\Facades\Log;
use App\Lib\JwtService;
use Illuminate\Support\Facades\Redis;
use App\Lib\AliSmsService;
use App\Models\Student;
use App\Models\AdminUserModel;
use App\Models\StudentEval;
use App\Models\FrontUserModel;
use App\Models\LoginCacheModel;
use App\Models\StudentConsult;
use App\Models\WxTokenModel;
use Illuminate\Support\Facades\Http;
use setasign\Fpdi\Fpdi;
use FPDF;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\Exceptions\Constants;

class LoginService
{
    const CAPTCHA_EXPIRE = 300;


    // 用户名正则校验规则, 字母数字下划线至少存在其中的两种, 长度6-20
    protected $userAccountNamePattern = '/^(?=.*[a-zA-Z])(?=.*[\d_])[\w]{6,20}$/';


    public static $wx_access_token_url = 'https://api.weixin.qq.com/cgi-bin/token?';
    public static $wx_code2session_url = 'https://api.weixin.qq.com/sns/jscode2session?';
    public static $wx_get_phone = 'https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=';
    public static $send_msg = 'https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=';

    public static $send_msg_template_id = 'GLlVWOELj1u3M6FMtd5bTAsYVfuVwr3ZW3uLo5hv2e0';


    public static function sendGetRequest($url)
    {
        $response = Http::get($url);

        // 你可以从响应中获取内容
        $bodyData = json_decode($response->body(), true);
        if(isset($bodyData['errcode']) && $bodyData['errcode'] != 0){
            return ['code' => 50001, 'msg' => '授权异常,未获取到openid', 'data' => $bodyData];
        }
        return ['code' => 0, 'msg' => 'success', 'data' =>$bodyData];
    }
    public function sendWXPostRequest($url, $data)
    {
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->post($url, $data);

        $bodyData = $response->json(); // 如果响应是 JSON 格式，解析为数组或对象
        if(isset($bodyData['errcode']) && $bodyData['errcode'] != 0){
            return ['code' => 50001, 'msg' => $bodyData['errmsg'], 'data' => $bodyData];
        }

        return ['code' => 0, 'msg' => 'success', 'data' =>$bodyData['phone_info']];
    }
    public function sendWXPostRequestForMSg($url, $data)
    {
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->post($url, $data);

        $bodyData = $response->json(); // 如果响应是 JSON 格式，解析为数组或对象
        if(isset($bodyData['errcode']) && $bodyData['errcode'] != 0){
            return ['code' => 50001, 'msg' => $bodyData['errmsg'], 'data' => $bodyData];
        }

        return ['code' => 0, 'msg' => 'success', 'data' =>$bodyData];
    }

    protected static function getWXAccessTokenService(){

        try {

            $wxTokenModel = new WxTokenModel();
            $accessTokenRet = $wxTokenModel->findData([], 'id', 'DESC');
            if(!empty($accessTokenRet)){
                $time = time();
                $cacheTime = strtotime($accessTokenRet['created_at']);
                if($time - $cacheTime <= 7000){
                    return ['code' => 0, 'msg' => 'success', 'data' => ['access_token' => $accessTokenRet['auth']]];
                }
            }

            //获取微信配置
            $appid = env('WX_APP_ID');
            $appSecret = env('WX_APP_SECRET');
            if(empty($appid) || empty($appSecret)){
                return ['code' => 50001, 'msg' => '系统异常,配置未获取到', 'data' => []];
            }
            $reqUrl = self::$wx_access_token_url.'grant_type=client_credential&appid='.$appid . '&secret='.$appSecret;
            $apiServiceRet  = self::sendGetRequest($reqUrl);
            if($apiServiceRet['code'] != 0){
                return $apiServiceRet;
            }
            $token = $apiServiceRet['data']['access_token'];


            $wxTokenModel->insertData(['auth'=>$token]);

            return ['code' => 0, 'msg' => 'success', 'data' => ['access_token' => $token]];

        } catch (\Exception $e) {
            Log::channel('errorlog')->error("getWXAccessTokenService: " . $e->getMessage());
            return ['code' => 50001, 'msg' => '系统异常', 'data' => $e->getMessage()];

        }
    }


    public function loginAppletHandle($openid, $platform, $phone = "", $userName = "") {

        $where = [
            'openid'=>$openid,
        ];
        $frontUserModel = new FrontUserModel();
        $findRetdata = $frontUserModel->findData($where);
        if (empty($findRetdata)){
            $insertUser = [
                'openid' => $openid,
                'user_name' => $userName,
                'phone' => $phone,
            ];
            $userId= $frontUserModel->insertData($insertUser);
        }else{
            $userId =$findRetdata['id'];
            $phone  = $findRetdata['phone'];
            $userName  = $findRetdata['user_name'];
        }

        $isNeedAuth = 0;
        if(empty($phone)){
            $isNeedAuth = 1;
        }
        //生成auth
        $info = [
            'id' => $userId,
            'phone' => $phone,
            'platform' => $platform,
        ];
        $auth  = JwtService::createToken($info, $platform);
        $insert = [
            'auth' => $auth,
            'uid' => $userId,
            'type' => 2,
        ];
        $LoginCacheModel = new LoginCacheModel();
        $LoginCacheModel->insertData($insert);

        return ['code'=>0, 'msg'=>'success','data'=>['Authorization'=>$auth, 'phone'=>$phone,'user_name'=>$userName, 'openid'=>$openid,
            'isNeedAuth'=> $isNeedAuth, 'info'=>$info]];

    }

    //小程序登录
    public function getWxLoginService($code, $platform){

        try {

            $appid = env('WX_APP_ID');
            $appSecret = env('WX_APP_SECRET');
            if(empty($appid) || empty($appSecret)){
                return ['code' => 50001, 'msg' => '系统异常,配置未获取到', 'data' => []];
            }

            $param = 'appid='.$appid.'&secret='.$appSecret.'&js_code='.$code.'&grant_type=authoriza';
            $reqUrl = self::$wx_code2session_url.$param;
            $apiServiceRet  = self::sendGetRequest($reqUrl);
            if($apiServiceRet['code'] != 0){
                return $apiServiceRet;
            }
            if($apiServiceRet['code'] != 0){
                return $apiServiceRet;
            }

            //获取用户信息
            $loginRet =  $this->loginAppletHandle($apiServiceRet['data']['openid'], $platform, "", '');
            if($loginRet['code'] != 0){
                return $loginRet;
            }

            return ['code' => 0, 'msg' => 'success', 'data' =>$loginRet['data']];

        } catch (\Exception $e) {
            return ['code' => 50001, 'msg' => '系统异常', 'data' => ['msg' => "registerService: " . $e->getMessage()]];

        }
    }


    public function loginHandle($phone, $passwd, $platform) {

        $where = [
            'phone'=>$phone,
            'pwd'=>$passwd,
        ];
        $userfrontModel = new AdminUserModel();
        $findRetdata = $userfrontModel->findData($where);
        if (empty($findRetdata)){
            return ['code'=>10001, 'msg'=>'不存在的账号信息','data'=>[]];
        }
        if($findRetdata['status'] == 0){
            return ['code'=>10001, 'msg'=>'账号已被禁用','data'=>[]];
        }

        //生成auth
        $info = [
            'id' => $findRetdata['id'],
            'phone' => $findRetdata['phone'],
            'platform' => $platform,
        ];
        $auth  = JwtService::createToken($info, $platform);
        $insert = [
            'auth' => $auth,
            'uid' => $findRetdata['id'],
            'type' => 1,
        ];
        $LoginCacheModel = new LoginCacheModel();
        $LoginCacheModel->insertData($insert);

        return ['code'=>0, 'msg'=>'success','data'=>['Authorization'=>$auth, 'phone'=>$findRetdata['phone'] ,'is_admin'=>$findRetdata['is_admin'] ]];

    }

    public function getWxPhoneService($code, $openid, $platform, $owner = ""){

        try {
            $accessTokenRet = self::getWXAccessTokenService();
            if($accessTokenRet['code'] != 0){
                return $accessTokenRet;
            }
            $param = [
                'code' => $code,
                'openid' => $openid,
            ];
            $reqUrl = self::$wx_get_phone.$accessTokenRet['data']['access_token'];
            $apiServiceRet  = self::sendWXPostRequest($reqUrl, $param);
            if($apiServiceRet['code'] != 0){
                return $apiServiceRet;
            }
            $phoneInfo = $apiServiceRet['data'];
            //如果走到这一步，那就需要注册用户并登录
            $authRet = $this->loginAppletHandleForGetPhone($openid, $platform, $phoneInfo['purePhoneNumber'], $owner);
            if($authRet['code'] != 0){
                return $authRet;
            }
            return ['code' => 0, 'msg' => 'success', 'data' =>$authRet['data']];

        } catch (\Exception $e) {

            Log::channel('errorlog')->error("registerService: " . $e->getMessage());
            return ['code' => 50001, 'msg' => '系统异常', 'data' => [$e->getMessage()]];

        }
    }


    public function loginAppletHandleForGetPhone($openid, $platform, $phone, $owner ) {

        $where = [
            'openid'=>$openid,
        ];
        $frontUserModel = new FrontUserModel();
        $findRetdata = $frontUserModel->findData($where);
        if (empty($findRetdata)){
            $insertUser = [
                'openid' => $openid,
                'phone' => $phone,
                'referrer_name' => $owner,
            ];
            $userId= $frontUserModel->insertData($insertUser);
        }else{
            $insertUser = [
                'phone' => $phone,
                'referrer_name' => $owner,
            ];
            $frontUserModel->updateData($where ,$insertUser);
            $userId = $findRetdata['id'];
        }

        $isNeedAuth = 0;

        //生成auth
        $info = [
            'id' => $userId,
            'phone' => $phone,
            'platform' => $platform,
        ];
        $auth  = JwtService::createToken($info, $platform);
        $insert = [
            'auth' => $auth,
            'uid' => $userId,
            'type' => 2,
        ];
        $LoginCacheModel = new LoginCacheModel();
        $LoginCacheModel->insertData($insert);

        return ['code'=>0, 'msg'=>'success','data'=>['Authorization'=>$auth, 'phone'=>$phone,'user_name'=>"", 'openid'=>$openid,
            'isNeedAuth'=> $isNeedAuth, 'info'=>$info]];

    }


    public function studentInfoSubmitService($name, $phone, $baseInfo)
    {

        try {

            $uuid = Constants::getUUID();
            $student = new Student();

            $findData = $student->findData(['phone'=>$phone]);
            if(!empty($findData)){
                return ['code'=>10002, 'msg'=>'已经提交过信息，无需重复提交', 'data'=>[]];
            }

            $insertId = $student->insertData([
                'name'=>$name,
                'phone'=>$phone,
                'base_info'=>$baseInfo,
                'uuid'=>$uuid,
            ]);

            return ['code'=>0, 'msg'=>'success', 'data'=>['id'=>$uuid]];


        } catch (\Exception $e) {
            return ['code'=>20001, 'msg'=>'系统异常，请稍后重试', 'data'=>[]];
        }
    }



    public function studentIntentionInfoSubmitService($id, $intentionInfo)
    {

        try {

            $student = new Student();
            $findData = $student->findData(['uuid'=>$id]);
            if(empty($findData)){
                return ['code'=>10002, 'msg'=>'请先填写基本信息', 'data'=>[]];
            }
            $ret = $student->updateData(['uuid'=>$id], ['intention_info'=>$intentionInfo,]);

            return ['code'=>0, 'msg'=>'success', 'data'=>[]];

        } catch (\Exception $e) {
            return ['code'=>20001, 'msg'=>'系统异常，请稍后重试', 'data'=>[]];
        }
    }

    public function studentScoreInfoSubmitService($id, $scoreInfo)
    {

        try {

            $student = new Student();
            $findData = $student->findData(['uuid'=>$id]);
            if(empty($findData)){
                return ['code'=>10002, 'msg'=>'请先填写基本信息', 'data'=>[]];
            }
            $ret = $student->updateData(['uuid'=>$id], ['score_info'=>$scoreInfo,]);

            return ['code'=>0, 'msg'=>'success', 'data'=>[]];

        } catch (\Exception $e) {
            return ['code'=>20001, 'msg'=>'系统异常，请稍后重试', 'data'=>[]];
        }
    }


    public function studentEvalSubmitService($name, $phone, $weight, $evalInfo)
    {

        try {

            $studentEval = new StudentEval();

            $findData = $studentEval->findData(['phone'=>$phone]);
            if(!empty($findData)){
                return ['code'=>10002, 'msg'=>'已经提交过信息，无需重复提交', 'data'=>[]];
            }

            $insertId = $studentEval->insertData([
                'user_name'=>$name,
                'phone'=>$phone,
                'eval_info'=>$evalInfo,
                'weight_info'=>$weight,
            ]);

            return ['code'=>0, 'msg'=>'success', 'data'=>['id'=>$insertId]];


        } catch (\Exception $e) {
            return ['code'=>20001, 'msg'=>'系统异常，请稍后重试', 'data'=>[]];
        }
    }

    public function studentConsultSubmitService($name, $phone, $info)
    {

        try {

            $studentConsult = new StudentConsult();

            $findData = $studentConsult->findData(['phone'=>$phone]);
            if(!empty($findData)){
                return ['code'=>10002, 'msg'=>'已经提交过信息，无需重复提交', 'data'=>[]];
            }

            $insertId = $studentConsult->insertData([
                'user_name'=>$name,
                'phone'=>$phone,
                'info'=>$info,
            ]);

            return ['code'=>0, 'msg'=>'success', 'data'=>['id'=>$insertId]];


        } catch (\Exception $e) {
            return ['code'=>20001, 'msg'=>'系统异常，请稍后重试', 'data'=>[]];
        }
    }

    public function checkCommonPreferenceMajorHandle($studentInfo) {
        $result = [
            'res' => false,
            'msg' => '校验成功',
            'data' => [],
        ];

        if (!isset($studentInfo['user_name']) || mb_strlen($studentInfo['user_name']) == 0 || mb_strlen($studentInfo['user_name']) > 32) {
            $result['msg'] = '姓名异常';
            return $result;
        }
        $result['data']['user_name'] = $studentInfo['user_name'];

        if (!isset($studentInfo['phone']) || !checkPhone($studentInfo['phone'])) {
            $result['msg'] = '手机号异常';
            return $result;
        }
        $result['data']['phone'] = $studentInfo['phone'];

        if (!isset($studentInfo['province']) || mb_strlen($studentInfo['province']) == 0 || mb_strlen($studentInfo['province']) > 32) {
            $result['msg'] = '省份异常';
            return $result;
        }
        $result['data']['province'] = $studentInfo['province'];

        if (!isset($studentInfo['subject']) || mb_strlen($studentInfo['subject']) == 0 || mb_strlen($studentInfo['subject']) > 32) {
            $result['msg'] = '选科异常';
            return $result;
        }
        $result['data']['subject'] = $studentInfo['subject'];

        if (!isset($studentInfo['score']) || !is_numeric($studentInfo['score']) || $studentInfo['score'] < 0 || $studentInfo['score'] > 99999.9) {
            $result['msg'] = '分数异常';
            return $result;
        }
        $result['data']['score'] = round($studentInfo['score'], 1);

        if (!isset($studentInfo['rank']) || !is_numeric($studentInfo['rank']) || $studentInfo['rank'] <= 0 || $studentInfo['rank'] > 99999999) {
            $result['msg'] = '分数异常';
            return $result;
        }
        $result['data']['rank'] = intval($studentInfo['rank']);

        if (!isset($studentInfo['type']) || !is_numeric($studentInfo['type']) || ($studentInfo['type'] != 1 && $studentInfo['type'] != 2)) {
            $result['msg'] = '类型异常';
            return $result;
        }
        $result['data']['type'] = intval($studentInfo['type']);

        if (!isset($studentInfo['plan']) || !is_array($studentInfo['plan']) || empty($studentInfo['plan']) || count($studentInfo['plan']) > 120) {
            $result['msg'] = '志愿异常';
            return $result;
        }

        $result['data']['plan'] = [];
        if ($studentInfo['type'] == 1) {
            foreach ($studentInfo['plan'] as $index => $plan) {
                if (!isset($plan['school_code']) || mb_strlen($plan['school_code']) == 0 || mb_strlen($plan['school_code']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个院校代码异常';
                    return $result;
                }
                if (!isset($plan['school_name']) || mb_strlen($plan['school_name']) == 0 || mb_strlen($plan['school_name']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个院校名称异常';
                    return $result;
                }
                if (!isset($plan['major_code']) || mb_strlen($plan['major_code']) == 0 || mb_strlen($plan['major_code']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业代码异常';
                    return $result;
                }
                if (!isset($plan['major_name']) || mb_strlen($plan['major_name']) == 0 || mb_strlen($plan['major_name']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业名称异常';
                    return $result;
                }

                $result['data']['plan'][] = [
                    'school_code' => $plan['school_code'],
                    'school_name' => $plan['school_name'],
                    'major_code' => $plan['major_code'],
                    'major_name' => $plan['major_name'],
                ];
            }
        } else if ($studentInfo['type'] == 2) {
            foreach ($studentInfo['plan'] as $index => $plan) {
                if (!isset($plan['school_code']) || mb_strlen($plan['school_code']) == 0 || mb_strlen($plan['school_code']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个院校代码异常';
                    return $result;
                }
                if (!isset($plan['major_name_1']) || mb_strlen($plan['major_name_1']) == 0 || mb_strlen($plan['major_name_1']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业1异常';
                    return $result;
                }
                if (!isset($plan['major_code_1']) || mb_strlen($plan['major_code_1']) == 0 || mb_strlen($plan['major_code_1']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业1代码异常';
                    return $result;
                }
                if (!isset($plan['major_name_2']) || mb_strlen($plan['major_name_2']) == 0 || mb_strlen($plan['major_name_2']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业2异常';
                    return $result;
                }
                if (!isset($plan['major_code_2']) || mb_strlen($plan['major_code_2']) == 0 || mb_strlen($plan['major_code_2']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业2代码异常';
                    return $result;
                }
                if (!isset($plan['major_name_3']) || mb_strlen($plan['major_name_3']) == 0 || mb_strlen($plan['major_name_3']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业3异常';
                    return $result;
                }
                if (!isset($plan['major_code_3']) || mb_strlen($plan['major_code_3']) == 0 || mb_strlen($plan['major_code_3']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业3代码异常';
                    return $result;
                }
                if (!isset($plan['major_name_4']) || mb_strlen($plan['major_name_4']) == 0 || mb_strlen($plan['major_name_4']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业4异常';
                    return $result;
                }
                if (!isset($plan['major_code_4']) || mb_strlen($plan['major_code_4']) == 0 || mb_strlen($plan['major_code_4']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业4代码异常';
                    return $result;
                }
                if (!isset($plan['major_name_5']) || mb_strlen($plan['major_name_5']) == 0 || mb_strlen($plan['major_name_5']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业5异常';
                    return $result;
                }
                if (!isset($plan['major_code_5']) || mb_strlen($plan['major_code_5']) == 0 || mb_strlen($plan['major_code_5']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业5代码异常';
                    return $result;
                }
                if (!isset($plan['major_name_6']) || mb_strlen($plan['major_name_6']) == 0 || mb_strlen($plan['major_name_6']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业6异常';
                    return $result;
                }
                if (!isset($plan['major_code_6']) || mb_strlen($plan['major_code_6']) == 0 || mb_strlen($plan['major_code_6']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个专业6代码异常';
                    return $result;
                }
                if (!isset($plan['is_obey_adjust']) || mb_strlen($plan['is_obey_adjust']) == 0 || mb_strlen($plan['is_obey_adjust']) > 64) {
                    $result['msg'] = '第' . ($index + 1) . '个是否服从调剂异常';
                    return $result;
                }

                $result['data']['plan'][] = [
                    'school_code' => $plan['school_code'],
                    'major_code' => $plan['major_code'],
                    'major_name_1' => $plan['major_name_1'],
                    'major_code_1' => $plan['major_code_1'],
                    'major_name_2' => $plan['major_name_2'],
                    'major_code_2' => $plan['major_code_2'],
                    'major_name_3' => $plan['major_name_3'],
                    'major_code_3' => $plan['major_code_3'],
                    'major_name_4' => $plan['major_name_4'],
                    'major_code_4' => $plan['major_code_4'],
                    'major_name_5' => $plan['major_name_5'],
                    'major_code_5' => $plan['major_code_5'],
                    'major_name_6' => $plan['major_name_6'],
                    'major_code_6' => $plan['major_code_6'],
                    'is_obey_adjust' => $plan['is_obey_adjust'],
                ];
            }
        }

        $result['res'] = true;
        return $result;
    }

    public function commonPreferenceMajorHandle($studentInfo) {
        $result = [
            'res' => false,
            'msg' => '提交成功',
            'data' => [],
        ];

        $studentPreferenceMajorModel = new StudentPreferenceMajor();
        $info = $studentPreferenceMajorModel->findDataWithField(['phone' => $studentInfo['phone'], 'type' => $studentInfo['type']], ['id']);
        if (!empty($info)) {
            $result['msg'] = '您已提交过信息,无需重复提交';
            return $result;
        }

        $insertData = [
            'user_name' => $studentInfo['user_name'],
            'phone' => $studentInfo['phone'],
            'province' => $studentInfo['province'],
            'subject' => $studentInfo['subject'],
            'score' => $studentInfo['score'],
            'rank' => $studentInfo['rank'],
            'type' => $studentInfo['type'],
            'plan' => json_encode($studentInfo['plan'], JSON_UNESCAPED_UNICODE),
        ];
        $insertRes = $studentPreferenceMajorModel->insertData($insertData);
        if (false === $insertRes) {
            $result['msg'] = '提交失败';
            return $result;
        }

        $result['res'] = true;
        return $result;
    }

    public function parentsIntentionPeriodsHandle() {
        $result = [
            'res' => false,
            'msg' => '获取成功',
            'data' => [],
        ];

        $configModel = new Config();
        $periods = $configModel->findDataWithField(['type' => 1, 'config_key' => 'intention_' . date('Y')]);
        if (empty($periods)) {
            $result['msg'] = '报名期数配置异常';
            return $result;
        }

        $result['res'] = true;
        $result['data']['periods'] = json_decode($periods['config_value'], true);
        return $result;
    }

    public function checkParentsIntentionHandle($studentInfo) {
        $result = [
            'res' => false,
            'msg' => '校验成功',
            'data' => [],
        ];

        if (!isset($studentInfo['user_name']) || mb_strlen($studentInfo['user_name']) == 0 || mb_strlen($studentInfo['user_name']) > 32) {
            $result['msg'] = '姓名异常';
            return $result;
        }
        $result['data']['user_name'] = $studentInfo['user_name'];

        if (!isset($studentInfo['phone']) || !checkPhone($studentInfo['phone'])) {
            $result['msg'] = '手机号异常';
            return $result;
        }
        $result['data']['phone'] = $studentInfo['phone'];

        if (!isset($studentInfo['province']) || mb_strlen($studentInfo['province']) == 0 || mb_strlen($studentInfo['province']) > 32) {
            $result['msg'] = '省份异常';
            return $result;
        }
        $result['data']['province'] = $studentInfo['province'];

        if (!isset($studentInfo['periods']) || !is_numeric($studentInfo['periods']) || $studentInfo['periods'] < 1 || $studentInfo['periods'] > 4) {
            $result['msg'] = '期数异常';
            return $result;
        }
        $result['data']['periods'] = intval($studentInfo['periods']);

        $result['res'] = true;
        return $result;
    }

    public function parentsIntentionHandle($studentInfo) {
        $result = [
            'res' => false,
            'msg' => '提交成功',
            'data' => [],
        ];

        $year = date('Y');

        $parentsIntention = new ParentsIntention();
        $info = $parentsIntention->findDataWithField(['phone' => $studentInfo['phone'], 'year' => $year], ['id']);
        if (!empty($info)) {
            $result['msg'] = '您已提交过信息,无需重复提交';
            return $result;
        }

        $insertData = [
            'user_name' => $studentInfo['user_name'],
            'phone' => $studentInfo['phone'],
            'province' => $studentInfo['province'],
            'year' => $year,
            'periods' => $studentInfo['periods'],
        ];
        $insertRes = $parentsIntention->insertData($insertData);
        if (false === $insertRes) {
            $result['msg'] = '提交失败';
            return $result;
        }

        $result['res'] = true;
        return $result;
    }


}





